/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.junit5;

import io.bootique.resource.ResourceFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.Assertions;

@Deprecated(since="3.0", forRemoval=true)
public class ResponseMatcher {
    private final Response response;
    private final AtomicBoolean contentRead;

    public ResponseMatcher(Response response) {
        this.response = response;
        this.contentRead = new AtomicBoolean(false);
    }

    public ResponseMatcher assertStatus(int expectedStatus) {
        Assertions.assertEquals((int)expectedStatus, (int)this.response.getStatus());
        return this;
    }

    public ResponseMatcher assertStatus(int expectedStatus, String message) {
        Assertions.assertEquals((int)expectedStatus, (int)this.response.getStatus(), (String)message);
        return this;
    }

    public ResponseMatcher assertOk() {
        return this.assertStatus(200);
    }

    public ResponseMatcher assertOk(String message) {
        return this.assertStatus(200, message);
    }

    public ResponseMatcher assertCreated() {
        return this.assertStatus(201);
    }

    public ResponseMatcher assertCreated(String message) {
        return this.assertStatus(201, message);
    }

    public ResponseMatcher assertFound() {
        return this.assertStatus(302);
    }

    public ResponseMatcher assertFound(String message) {
        return this.assertStatus(302, message);
    }

    public ResponseMatcher assertTempRedirect() {
        return this.assertStatus(307);
    }

    public ResponseMatcher assertTempRedirect(String message) {
        return this.assertStatus(307, message);
    }

    public ResponseMatcher assertBadRequest() {
        return this.assertStatus(400);
    }

    public ResponseMatcher assertBadRequest(String message) {
        return this.assertStatus(400, message);
    }

    public ResponseMatcher assertUnauthorized() {
        return this.assertStatus(401);
    }

    public ResponseMatcher assertUnauthorized(String message) {
        return this.assertStatus(401, message);
    }

    public ResponseMatcher assertForbidden() {
        return this.assertStatus(403);
    }

    public ResponseMatcher assertForbidden(String message) {
        return this.assertStatus(403, message);
    }

    public ResponseMatcher assertNotFound() {
        return this.assertStatus(404);
    }

    public ResponseMatcher assertNotFound(String message) {
        return this.assertStatus(404, message);
    }

    public ResponseMatcher assertContent(String expectedContent) {
        Assertions.assertEquals((Object)expectedContent, (Object)this.getContentAsString());
        return this;
    }

    public ResponseMatcher assertContent(String expectedContent, String message) {
        Assertions.assertEquals((Object)expectedContent, (Object)this.getContentAsString(), (String)message);
        return this;
    }

    public ResponseMatcher assertContent(Consumer<String> assertionChecker) {
        assertionChecker.accept(this.getContentAsString());
        return this;
    }

    public ResponseMatcher assertContent(ResourceFactory expectedContentSource) {
        return this.assertContent(this.resourceContent(expectedContentSource, "UTF-8"));
    }

    protected String resourceContent(ResourceFactory resource, String encoding) {
        String string;
        block9: {
            URL url = resource.getUrl();
            InputStream in = url.openStream();
            try {
                int nRead;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((nRead = in.read(data, 0, data.length)) != -1) {
                    out.write(data, 0, nRead);
                }
                string = new String(out.toByteArray(), encoding);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading resource contents: " + url, e);
                }
            }
            in.close();
        }
        return string;
    }

    public ResponseMatcher assertContentType(MediaType expectedType) {
        String header = this.response.getHeaderString("Content-Type");
        Assertions.assertNotNull((Object)header, (String)"'Content-Type' is undefined");
        MediaType actualType = MediaType.valueOf((String)header);
        Assertions.assertTrue((boolean)expectedType.isCompatible(actualType), () -> "'" + header + "' is not compatible with '" + expectedType + "'");
        return this;
    }

    public ResponseMatcher assertContentType(String expectedType) {
        String header = this.response.getHeaderString("Content-Type");
        Assertions.assertNotNull((Object)header, (String)"'Content-Type' is undefined");
        MediaType expectedMT = MediaType.valueOf((String)expectedType);
        MediaType actualType = MediaType.valueOf((String)header);
        Assertions.assertTrue((boolean)expectedMT.isCompatible(actualType), () -> "'" + header + "' is not compatible with '" + expectedType + "'");
        return this;
    }

    public ResponseMatcher assertHeader(String headerName, String expectedValue) {
        String actualValue = this.response.getHeaderString(headerName);
        Assertions.assertNotNull((Object)actualValue, (String)("'" + headerName + "' is undefined"));
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue);
        return this;
    }

    public ResponseMatcher assertNoHeader(String headerName) {
        Assertions.assertNull((Object)this.response.getHeaderString(headerName));
        return this;
    }

    public <T> T getContent(Class<T> type) {
        this.checkCanReadContent();
        return (T)this.response.readEntity(type);
    }

    public <T> T getContent(GenericType<T> type) {
        this.checkCanReadContent();
        return (T)this.response.readEntity(type);
    }

    public String getContentAsString() {
        return this.getContent(String.class);
    }

    public byte[] getContentAsBytes() {
        this.checkCanReadContent();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = (InputStream)this.response.readEntity(InputStream.class);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer, 0, buffer.length)) >= 0) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private void checkCanReadContent() {
        if (!this.contentRead.compareAndSet(false, true)) {
            throw new IllegalStateException("Response data is already read");
        }
    }
}

