/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.bootique.BQCoreModule;
import io.bootique.BQCoreModuleExtender;
import io.bootique.ConfigModule;
import io.bootique.config.ConfigurationFactory;
import io.bootique.jetty.JettyModuleExtender;
import io.bootique.jetty.MappedFilter;
import io.bootique.jetty.MappedServlet;
import io.bootique.jetty.command.ServerCommand;
import io.bootique.jetty.server.MappedFilterFactory;
import io.bootique.jetty.server.MappedServletFactory;
import io.bootique.jetty.server.ServerFactory;
import io.bootique.jetty.servlet.DefaultServletEnvironment;
import io.bootique.jetty.servlet.ServletEnvironment;
import io.bootique.log.BootLogger;
import io.bootique.shutdown.ShutdownManager;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;

public class JettyModule
extends ConfigModule {
    private String context;
    private int port;

    public JettyModule(String configPrefix) {
        super(configPrefix);
    }

    public JettyModule() {
    }

    public static JettyModuleExtender extend(Binder binder) {
        return new JettyModuleExtender(binder);
    }

    @Deprecated
    public static Multibinder<MappedServlet> contributeMappedServlets(Binder binder) {
        return JettyModule.extend(binder).contributeMappedServlets();
    }

    @Deprecated
    public static Multibinder<Servlet> contributeServlets(Binder binder) {
        return JettyModule.extend(binder).contributeServlets();
    }

    @Deprecated
    public static void contributeStaticServlet(Binder binder, String name, String ... urlPatterns) {
        JettyModule.extend(binder).addServlet((Servlet)new DefaultServlet(), name, urlPatterns);
    }

    @Deprecated
    public static void contributeDefaultServlet(Binder binder) {
        JettyModule.extend(binder).useDefaultServlet();
    }

    @Deprecated
    public static Multibinder<Filter> contributeFilters(Binder binder) {
        return JettyModule.extend(binder).contributeFilters();
    }

    @Deprecated
    public static Multibinder<MappedFilter> contributeMappedFilters(Binder binder) {
        return JettyModule.extend(binder).contributeMappedFilters();
    }

    @Deprecated
    public static Multibinder<EventListener> contributeListeners(Binder binder) {
        return JettyModule.extend(binder).contributeListeners();
    }

    static int maxOrder(Set<MappedFilter> mappedFilters) {
        return mappedFilters.stream().map(MappedFilter::getOrder).max(Integer::compare).orElse(0);
    }

    public JettyModule context(String context) {
        this.context = context;
        return this;
    }

    public JettyModule port(int port) {
        this.port = port;
        return this;
    }

    public void configure(Binder binder) {
        BQCoreModuleExtender coreExtender = BQCoreModule.extend((Binder)binder).addCommand(ServerCommand.class).setLogLevel("org.eclipse.jetty", Level.INFO);
        if (this.context != null) {
            coreExtender.setProperty("bq." + this.configPrefix + ".context", this.context);
        }
        if (this.port > 0) {
            coreExtender.setProperty("bq." + this.configPrefix + ".connector.port", String.valueOf(this.port));
        }
        JettyModule.extend(binder).initAllExtensions().addListener(DefaultServletEnvironment.class);
    }

    @Singleton
    @Provides
    ServletEnvironment createStateTracker(DefaultServletEnvironment stateImpl) {
        return stateImpl;
    }

    @Singleton
    @Provides
    DefaultServletEnvironment createStateTrackerImpl() {
        return new DefaultServletEnvironment();
    }

    @Singleton
    @Provides
    Server createServer(ServerFactory factory, Set<Servlet> servlets, Set<MappedServlet> mappedServlets, Set<Filter> filters, Set<MappedFilter> mappedFilters, Set<EventListener> listeners, BootLogger bootLogger, ShutdownManager shutdownManager) {
        Server server = factory.createServer(this.allServlets(servlets, mappedServlets), this.allFilters(filters, mappedFilters), listeners);
        shutdownManager.addShutdownHook(() -> {
            bootLogger.trace(() -> "stopping Jetty...");
            server.stop();
        });
        return server;
    }

    private Set<MappedServlet> allServlets(Set<Servlet> servlets, Set<MappedServlet> mappedServlets) {
        if (servlets.isEmpty()) {
            return mappedServlets;
        }
        HashSet<MappedServlet> mappedServletsClone = new HashSet<MappedServlet>(mappedServlets);
        MappedServletFactory mappedServletFactory = new MappedServletFactory();
        servlets.forEach(servlet -> mappedServletsClone.add(mappedServletFactory.toMappedServlet((Servlet)servlet)));
        return mappedServletsClone;
    }

    private Set<MappedFilter> allFilters(Set<Filter> filters, Set<MappedFilter> mappedFilters) {
        if (filters.isEmpty()) {
            return mappedFilters;
        }
        AtomicInteger order = new AtomicInteger(JettyModule.maxOrder(mappedFilters) + 1);
        HashSet<MappedFilter> mappeFiltersClone = new HashSet<MappedFilter>(mappedFilters);
        MappedFilterFactory mappedFilterFactory = new MappedFilterFactory();
        filters.forEach(filter -> mappeFiltersClone.add(mappedFilterFactory.toMappedFilter((Filter)filter, order.getAndIncrement())));
        return mappeFiltersClone;
    }

    @Singleton
    @Provides
    ServerFactory createServerFactory(ConfigurationFactory configFactory) {
        return (ServerFactory)configFactory.config(ServerFactory.class, this.configPrefix);
    }
}

