/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.connector;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.config.PolymorphicConfiguration;
import io.bootique.jetty.connector.HttpConnectorFactory;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@BQConfig
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=HttpConnectorFactory.class)
public abstract class ConnectorFactory
implements PolymorphicConfiguration {
    private int port = 8080;
    private String host;
    private int responseHeaderSize = 8192;
    private int requestHeaderSize = 8192;

    public NetworkConnector createConnector(Server server) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        ConnectionFactory[] connectionFactories = this.buildHttpConnectionFactories(httpConfig);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        int selectorThreads = Runtime.getRuntime().availableProcessors();
        int acceptorThreads = Math.max(1, selectorThreads / 2);
        ThreadPool threadPool = Objects.requireNonNull(server.getThreadPool());
        ServerConnector connector = new ServerConnector(server, (Executor)threadPool, (Scheduler)scheduler, bufferPool, acceptorThreads, selectorThreads, connectionFactories);
        connector.setPort(this.getPort());
        connector.setIdleTimeout(30000L);
        connector.setHost(this.getHost());
        return connector;
    }

    protected abstract ConnectionFactory[] buildHttpConnectionFactories(HttpConfiguration var1);

    protected HttpConfiguration buildHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setHeaderCacheSize(512);
        httpConfig.setOutputBufferSize(32768);
        httpConfig.setRequestHeaderSize(this.requestHeaderSize);
        httpConfig.setResponseHeaderSize(this.responseHeaderSize);
        httpConfig.setSendDateHeader(true);
        httpConfig.setSendServerVersion(true);
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        return httpConfig;
    }

    protected ByteBufferPool buildBufferPool() {
        return new ArrayByteBufferPool(64, 1024, 65536);
    }

    public int getPort() {
        return this.port;
    }

    @BQConfigProperty
    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    @BQConfigProperty
    public void setHost(String host) {
        this.host = host;
    }

    public int getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    @BQConfigProperty
    public void setRequestHeaderSize(int requestHeaderSize) {
        this.requestHeaderSize = requestHeaderSize;
    }

    public int getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    @BQConfigProperty
    public void setResponseHeaderSize(int responseHeaderSize) {
        this.responseHeaderSize = responseHeaderSize;
    }
}

