/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.jetty.MappedFilter;
import io.bootique.jetty.MappedServlet;
import io.bootique.jetty.connector.ConnectorFactory;
import io.bootique.jetty.connector.HttpConnectorFactory;
import io.bootique.jetty.server.ConnectorDescriptor;
import io.bootique.jetty.server.FilterFactory;
import io.bootique.jetty.server.RequestLogger;
import io.bootique.jetty.server.ServerLifecycleLogger;
import io.bootique.jetty.server.ServletFactory;
import io.bootique.resource.FolderResourceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BQConfig(value="Configures embedded Jetty server, including servlet spec objects, web server root location, connectors, thread pool parameters, etc.")
public class ServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFactory.class);
    @Deprecated
    protected ConnectorFactory connector;
    protected List<ConnectorFactory> connectors;
    protected String context = "/";
    protected int idleThreadTimeout = 60000;
    protected Map<String, FilterFactory> filters;
    protected int maxThreads = 1024;
    protected int minThreads = 4;
    protected int maxQueuedRequests = 1024;
    protected Map<String, ServletFactory> servlets;
    protected boolean sessions = true;
    private Map<String, String> params;
    private FolderResourceFactory staticResourceBase;
    private boolean compression = true;

    public Server createServer(Set<MappedServlet> servlets, Set<MappedFilter> filters, Set<EventListener> listeners) {
        QueuedThreadPool threadPool = this.createThreadPool();
        Server server = new Server((ThreadPool)threadPool);
        server.setStopAtShutdown(true);
        server.setStopTimeout(1000L);
        server.setHandler(this.createHandler(servlets, filters, listeners));
        this.createRequestLog(server);
        Collection<ConnectorFactory> connectorFactories = this.connectorFactories(server);
        ArrayList<ConnectorDescriptor> connectorDescriptors = new ArrayList<ConnectorDescriptor>(2);
        if (connectorFactories.isEmpty()) {
            LOGGER.warn("Jetty starts with no connectors configured. Is that expected?");
        } else {
            connectorFactories.forEach(cf -> {
                NetworkConnector connector = cf.createConnector(server);
                server.addConnector((Connector)connector);
                connectorDescriptors.add(new ConnectorDescriptor(connector));
            });
        }
        server.addLifeCycleListener((LifeCycle.Listener)new ServerLifecycleLogger(connectorDescriptors, this.context));
        return server;
    }

    protected Handler createHandler(Set<MappedServlet> servlets, Set<MappedFilter> filters, Set<EventListener> listeners) {
        int options = 0;
        if (this.sessions) {
            options |= 1;
        }
        ServletContextHandler handler = new ServletContextHandler(options);
        handler.setContextPath(this.context);
        if (this.params != null) {
            this.params.forEach((k, v) -> handler.setInitParameter(k, v));
        }
        if (this.staticResourceBase != null) {
            handler.setResourceBase(this.staticResourceBase.getUrl().toExternalForm());
        }
        if (this.compression) {
            handler.setGzipHandler(this.createGzipHandler());
        }
        this.installListeners(handler, listeners);
        this.installServlets(handler, servlets);
        this.installFilters(handler, filters);
        return handler;
    }

    protected GzipHandler createGzipHandler() {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setCheckGzExists(false);
        return gzipHandler;
    }

    protected void installServlets(ServletContextHandler handler, Set<MappedServlet> servlets) {
        servlets.forEach(mappedServlet -> this.getServletFactory(mappedServlet.getName()).createAndAddJettyServlet(handler, (MappedServlet)mappedServlet));
    }

    protected ServletFactory getServletFactory(String name) {
        ServletFactory factory = null;
        if (this.servlets != null && name != null) {
            factory = this.servlets.get(name);
        }
        return factory != null ? factory : new ServletFactory();
    }

    protected void installFilters(ServletContextHandler handler, Set<MappedFilter> filters) {
        this.sortedFilters(filters).forEach(mappedFilter -> this.getFilterFactory(mappedFilter.getName()).createAndAddJettyFilter(handler, (MappedFilter)mappedFilter));
    }

    protected FilterFactory getFilterFactory(String name) {
        FilterFactory factory = null;
        if (this.filters != null && name != null) {
            factory = this.filters.get(name);
        }
        return factory != null ? factory : new FilterFactory();
    }

    protected void installListeners(ServletContextHandler handler, Set<EventListener> listeners) {
        Optional sessionHandler = this.sessions ? Optional.of(handler.getSessionHandler()) : Optional.empty();
        listeners.forEach(listener -> {
            LOGGER.info("Adding listener {}", (Object)listener.getClass().getName());
            handler.addEventListener(listener);
            sessionHandler.ifPresent(sh -> sh.addEventListener(listener));
        });
    }

    private List<MappedFilter> sortedFilters(Set<MappedFilter> unsorted) {
        ArrayList<MappedFilter> sorted = new ArrayList<MappedFilter>(unsorted);
        Collections.sort(sorted, Comparator.comparing(MappedFilter::getOrder));
        return sorted;
    }

    protected Collection<ConnectorFactory> connectorFactories(Server server) {
        ArrayList<ConnectorFactory> connectorFactories = new ArrayList<ConnectorFactory>();
        if (this.connector != null) {
            LOGGER.warn("Using deprecated 'connector' property. Consider changing configuration to 'connectors'");
            connectorFactories.add(this.connector);
        }
        if (this.connectors != null) {
            connectorFactories.addAll(this.connectors);
        }
        if (connectorFactories.isEmpty()) {
            connectorFactories.add(new HttpConnectorFactory());
        }
        return connectorFactories;
    }

    protected QueuedThreadPool createThreadPool() {
        BlockingArrayQueue queue = new BlockingArrayQueue(this.minThreads, this.maxThreads, this.maxQueuedRequests);
        QueuedThreadPool threadPool = this.createThreadPool((BlockingQueue<Runnable>)queue);
        threadPool.setName("bootique-http");
        return threadPool;
    }

    protected QueuedThreadPool createThreadPool(BlockingQueue<Runnable> queue) {
        return new QueuedThreadPool(this.maxThreads, this.minThreads, this.idleThreadTimeout, queue);
    }

    protected void createRequestLog(Server server) {
        Logger logger = LoggerFactory.getLogger(RequestLogger.class);
        if (logger.isInfoEnabled()) {
            server.setRequestLog((RequestLog)new RequestLogger());
        }
    }

    public List<ConnectorFactory> getConnectors() {
        return this.connectors;
    }

    @BQConfigProperty(value="A list of objects specifying properties of the server network connectors.")
    public void setConnectors(List<ConnectorFactory> connectors) {
        this.connectors = connectors;
    }

    @BQConfigProperty(value="A map of servlet configurations by servlet name. ")
    public void setServlets(Map<String, ServletFactory> servlets) {
        this.servlets = servlets;
    }

    @BQConfigProperty(value="A map of servlet Filter configurations by filter name.")
    public void setFilters(Map<String, FilterFactory> filters) {
        this.filters = filters;
    }

    @Deprecated
    public ConnectorFactory getConnector() {
        return this.connector;
    }

    @Deprecated
    public void setConnector(ConnectorFactory connector) {
        this.connector = connector;
    }

    public String getContext() {
        return this.context;
    }

    @BQConfigProperty(value="Web application context path. Default is '/'.")
    public void setContext(String context) {
        this.context = context;
    }

    public int getIdleThreadTimeout() {
        return this.idleThreadTimeout;
    }

    @BQConfigProperty(value="A period in milliseconds specifying how long until an idle thread is terminated. ")
    public void setIdleThreadTimeout(int idleThreadTimeout) {
        this.idleThreadTimeout = idleThreadTimeout;
    }

    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    @BQConfigProperty(value="Maximum number of requests to queue if the thread pool is busy. If this number is exceeded, the server will start dropping requests.")
    public void setMaxQueuedRequests(int maxQueuedRequests) {
        this.maxQueuedRequests = maxQueuedRequests;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @BQConfigProperty(value="Maximum number of request processing threads in the pool.")
    public void setMaxThreads(int maxConnectorThreads) {
        this.maxThreads = maxConnectorThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    @BQConfigProperty(value="Minimal number of request processing threads in the pool.")
    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public Map<String, String> getParams() {
        return this.params != null ? Collections.unmodifiableMap(this.params) : Collections.emptyMap();
    }

    @BQConfigProperty(value="A map of application-specific key/value parameters that are used as \"init\" parameters of the ServletContext.")
    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public boolean isSessions() {
        return this.sessions;
    }

    @BQConfigProperty(value="A boolean specifying whether servlet sessions should be supported by Jetty. The default is 'true'")
    public void setSessions(boolean sessions) {
        this.sessions = sessions;
    }

    public FolderResourceFactory getStaticResourceBase() {
        return this.staticResourceBase;
    }

    @BQConfigProperty(value="Defines a base location for resources of the Jetty context. It can be a filesystem path, a URL or a special \"classpath:\" URL (giving the ability to bundle resources in the app, not unlike a JavaEE .war file). This setting only makes sense when some form of \"default\" servlet is in use, that will be responsible for serving static resources. See JettyModule.contributeStaticServlet(..) or JettyModule.contributeDefaultServlet(..). ")
    public void setStaticResourceBase(FolderResourceFactory staticResourceBase) {
        this.staticResourceBase = staticResourceBase;
    }

    public boolean isCompression() {
        return this.compression;
    }

    @BQConfigProperty(value="A boolean specifying whether gzip compression should be supported. When enabled responses will be compressed if a client indicates it supports compression via \"Accept-Encoding: gzip\" header. Default value is 'true'.")
    public void setCompression(boolean compression) {
        this.compression = compression;
    }
}

