/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty;

import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.bootique.BQCoreModule;
import io.bootique.ConfigModule;
import io.bootique.config.ConfigurationFactory;
import io.bootique.jetty.JettyModuleExtender;
import io.bootique.jetty.MappedFilter;
import io.bootique.jetty.MappedListener;
import io.bootique.jetty.MappedServlet;
import io.bootique.jetty.command.ServerCommand;
import io.bootique.jetty.server.MappedFilterFactory;
import io.bootique.jetty.server.MappedServletFactory;
import io.bootique.jetty.server.ServerFactory;
import io.bootique.jetty.server.ServletContextHandlerExtender;
import io.bootique.jetty.servlet.DefaultServletEnvironment;
import io.bootique.jetty.servlet.ServletEnvironment;
import io.bootique.log.BootLogger;
import io.bootique.shutdown.ShutdownManager;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Server;

public class JettyModule
extends ConfigModule {
    public JettyModule(String configPrefix) {
        super(configPrefix);
    }

    public JettyModule() {
    }

    public static JettyModuleExtender extend(Binder binder) {
        return new JettyModuleExtender(binder);
    }

    static int maxOrder(Set<MappedFilter> mappedFilters) {
        return mappedFilters.stream().map(MappedFilter::getOrder).max(Integer::compare).orElse(0);
    }

    public void configure(Binder binder) {
        BQCoreModule.extend((Binder)binder).addCommand(ServerCommand.class).setLogLevel("org.eclipse.jetty", Level.INFO);
        JettyModule.extend(binder).initAllExtensions().addListener(DefaultServletEnvironment.class);
    }

    @Singleton
    @Provides
    ServletEnvironment createStateTracker(DefaultServletEnvironment stateImpl) {
        return stateImpl;
    }

    @Singleton
    @Provides
    DefaultServletEnvironment createStateTrackerImpl() {
        return new DefaultServletEnvironment();
    }

    @Singleton
    @Provides
    Server createServer(ServerFactory factory, Set<Servlet> servlets, Set<MappedServlet> mappedServlets, Set<Filter> filters, Set<MappedFilter> mappedFilters, Set<EventListener> listeners, Set<MappedListener> mappedListeners, Set<ServletContextHandlerExtender> contextHandlerExtenders, BootLogger bootLogger, ShutdownManager shutdownManager) {
        Server server = factory.createServer(this.allServlets(servlets, mappedServlets), this.allFilters(filters, mappedFilters), this.allListeners(listeners, mappedListeners), contextHandlerExtenders);
        shutdownManager.addShutdownHook(() -> {
            bootLogger.trace(() -> "stopping Jetty...");
            server.stop();
        });
        return server;
    }

    private Set<MappedServlet> allServlets(Set<Servlet> servlets, Set<MappedServlet> mappedServlets) {
        if (servlets.isEmpty()) {
            return mappedServlets;
        }
        HashSet<MappedServlet> mappedServletsClone = new HashSet<MappedServlet>(mappedServlets);
        MappedServletFactory mappedServletFactory = new MappedServletFactory();
        servlets.forEach(servlet -> mappedServletsClone.add(mappedServletFactory.toMappedServlet((Servlet)servlet)));
        return mappedServletsClone;
    }

    private Set<MappedFilter> allFilters(Set<Filter> filters, Set<MappedFilter> mappedFilters) {
        if (filters.isEmpty()) {
            return mappedFilters;
        }
        AtomicInteger order = new AtomicInteger(JettyModule.maxOrder(mappedFilters) + 1);
        HashSet<MappedFilter> mappeFiltersClone = new HashSet<MappedFilter>(mappedFilters);
        MappedFilterFactory mappedFilterFactory = new MappedFilterFactory();
        filters.forEach(filter -> mappeFiltersClone.add(mappedFilterFactory.toMappedFilter((Filter)filter, order.getAndIncrement())));
        return mappeFiltersClone;
    }

    private Set<MappedListener> allListeners(Set<EventListener> listeners, Set<MappedListener> mappedListeners) {
        if (listeners.isEmpty()) {
            return mappedListeners;
        }
        HashSet<MappedListener> mappedListenersClone = new HashSet<MappedListener>(mappedListeners);
        listeners.forEach(listener -> mappedListenersClone.add(new MappedListener<EventListener>((EventListener)listener, Integer.MAX_VALUE)));
        return mappedListenersClone;
    }

    @Singleton
    @Provides
    ServerFactory providerServerFactory(ConfigurationFactory configFactory) {
        return (ServerFactory)configFactory.config(ServerFactory.class, this.configPrefix);
    }
}

