/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.connector;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.jetty.connector.ConnectorFactory;
import io.bootique.resource.ResourceFactory;
import java.net.URL;
import java.util.Objects;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@BQConfig
@JsonTypeName(value="https")
public class HttpsConnectorFactory
extends ConnectorFactory {
    private ResourceFactory keyStore;
    private String keyStorePassword = "changeit";
    private String certificateAlias;

    @BQConfigProperty
    public void setKeyStore(ResourceFactory keyStore) {
        this.keyStore = keyStore;
    }

    @BQConfigProperty
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @BQConfigProperty
    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    @Override
    protected ConnectionFactory[] buildHttpConnectionFactories(HttpConfiguration httpConfig) {
        return new ConnectionFactory[]{this.buildSslConnectorFactory(httpConfig), this.buildHttp1BackingConnectorFactory(httpConfig)};
    }

    protected SslConnectionFactory buildSslConnectorFactory(HttpConfiguration httpConfig) {
        Objects.requireNonNull(this.keyStore, "'keyStore' must be specified");
        SslContextFactory contextFactory = new SslContextFactory();
        URL keystoreUrl = this.keyStore.getUrl();
        contextFactory.setKeyStoreResource((Resource)new URLResource(keystoreUrl, null){});
        contextFactory.setKeyStorePassword(this.keyStorePassword);
        contextFactory.setCertAlias(this.certificateAlias);
        return new SslConnectionFactory(contextFactory, HttpVersion.HTTP_1_1.asString());
    }

    protected HttpConnectionFactory buildHttp1BackingConnectorFactory(HttpConfiguration httpConfig) {
        return new HttpConnectionFactory(httpConfig);
    }

    @Override
    protected HttpConfiguration buildHttpConfiguration() {
        HttpConfiguration config = super.buildHttpConfiguration();
        config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return config;
    }
}

