/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.annotation.BQConfig;
import io.bootique.jetty.MappedServlet;
import io.bootique.jetty.server.WebArtifactFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BQConfig
public class ServletFactory
extends WebArtifactFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletFactory.class);

    public Optional<ServletHolder> createAndAddJettyServlet(ServletContextHandler handler, MappedServlet mappedServlet) {
        Map<String, String> params;
        Objects.requireNonNull(mappedServlet.getServlet());
        Set<String> urlPatterns = this.getUrlPatterns(mappedServlet.getUrlPatterns());
        if (urlPatterns.isEmpty()) {
            LOGGER.info("Skipping unmapped servlet {}", (Object)mappedServlet.getServlet().getClass().getName());
            return Optional.empty();
        }
        ServletHolder holder = new ServletHolder(mappedServlet.getServlet());
        if (mappedServlet.getName() != null) {
            holder.setName(mappedServlet.getName());
        }
        if ((params = this.getParams(mappedServlet.getParams())) != null) {
            params.forEach((k, v) -> holder.setInitParameter(k, v));
        }
        urlPatterns.forEach(urlPattern -> {
            if (LOGGER.isInfoEnabled()) {
                String name = mappedServlet.getName() != null ? mappedServlet.getName() : "?";
                LOGGER.info("Adding servlet '{}' mapped to {}", (Object)name, urlPattern);
            }
            handler.addServlet(holder, urlPattern);
        });
        return Optional.of(holder);
    }
}

