/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.bifs;

import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.util.KeyDictionary;

@BoxBIF
public class HtmlFooter
extends BIF {
    public HtmlFooter() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.text, Set.of(Validator.NON_EMPTY))};
    }

    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String text = arguments.getAsString(Key.text).trim();
        HtmlFooter.addToFooter(context, text);
        return true;
    }

    public static void addToFooter(IBoxContext context, String text) {
        if (!context.hasAttachment(KeyDictionary.htmlFooter)) {
            context.putAttachment(KeyDictionary.htmlFooter, (Object)new Array());
            ((RequestBoxContext)context.getParentOfType(RequestBoxContext.class)).getApplicationListener().getInterceptorPool().register(data -> {
                IBoxContext dataContext = (IBoxContext)data.get((Object)Key.context);
                if (dataContext.hasAttachment(KeyDictionary.htmlHead)) {
                    Array headArray = (Array)dataContext.getAttachment(KeyDictionary.htmlHead);
                    StringBuffer buffer = dataContext.getBuffer();
                    Document doc = Jsoup.parse(buffer.toString());
                    Element body = doc.body();
                    for (Object item : headArray) {
                        body.append(item.toString());
                    }
                    dataContext.clearBuffer();
                    dataContext.writeToBuffer((Object)doc.toString());
                }
                return false;
            }, new Key[]{KeyDictionary.onRequestEnd});
        }
        Array footer = (Array)context.getAttachment(KeyDictionary.htmlFooter);
        footer.append((Object)text);
    }
}

