/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.bifs;

import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.util.KeyDictionary;

@BoxBIF
public class HtmlHead
extends BIF {
    public HtmlHead() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.text, Set.of(Validator.NON_EMPTY))};
    }

    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String text = arguments.getAsString(Key.text).trim();
        HtmlHead.addToHead(context, text);
        return true;
    }

    public static void addToHead(IBoxContext context, String text) {
        RequestBoxContext requestContext = (RequestBoxContext)context.getParentOfType(RequestBoxContext.class);
        if (!requestContext.hasAttachment(KeyDictionary.htmlHead)) {
            requestContext.putAttachment(KeyDictionary.htmlHead, (Object)new Array());
            requestContext.getApplicationListener().getInterceptorPool().register(data -> {
                IBoxContext dataContext = (IBoxContext)data.get((Object)Key.context);
                if (requestContext.hasAttachment(KeyDictionary.htmlHead)) {
                    Array headArray = (Array)requestContext.getAttachment(KeyDictionary.htmlHead);
                    StringBuffer buffer = dataContext.getBuffer();
                    Document doc = Jsoup.parse(buffer.toString());
                    Element headElement = doc.head();
                    if (headElement == null) {
                        headElement = doc.appendElement("head");
                    }
                    for (Object headContent : headArray) {
                        headElement.append((String)headContent);
                    }
                    dataContext.clearBuffer();
                    dataContext.writeToBuffer((Object)doc.toString());
                }
                return false;
            }, new Key[]{KeyDictionary.onRequestEnd});
        }
        Array head = (Array)requestContext.getAttachment(KeyDictionary.htmlHead);
        head.append((Object)text);
    }
}

