/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.components;

import java.io.File;
import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;

@BoxComponent(allowsBody=true)
public class Content
extends Component {
    public Content() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key.type, "string", Set.of(Validator.NON_EMPTY)), new Attribute(Key.deleteFile, "boolean", (Object)false), new Attribute(Key.file, "string"), new Attribute(Key.variable, "any"), new Attribute(Key.reset, "boolean", (Object)true)};
    }

    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        Component.BodyResult bodyResult;
        String type = attributes.getAsString(Key.type);
        Boolean deleteFile = attributes.getAsBoolean(Key.deleteFile);
        String file = attributes.getAsString(Key.file);
        Object variable = attributes.get((Object)Key.variable);
        Boolean reset = attributes.getAsBoolean(Key.reset);
        WebRequestBoxContext requestContext = (WebRequestBoxContext)((Object)context.getParentOfType(WebRequestBoxContext.class));
        IBoxHTTPExchange exchange = requestContext.getHTTPExchange();
        if (type != null) {
            exchange.setResponseHeader("content-type", type);
        }
        if (file != null) {
            file = FileSystemUtil.expandPath((IBoxContext)context, (String)file).absolutePath().toString();
            context.clearBuffer();
            exchange.sendResponseFile(new File(file));
            if (deleteFile.booleanValue()) {
                FileSystemUtil.deleteFile((String)file);
            }
            throw new AbortException();
        }
        if (variable != null) {
            byte[] bytesToWrite;
            if (reset.booleanValue()) {
                context.clearBuffer();
            } else {
                context.flushBuffer(false);
            }
            if (variable instanceof byte[]) {
                byte[] barr = (byte[])variable;
                bytesToWrite = barr;
            } else {
                bytesToWrite = StringCaster.cast((Object)variable).getBytes();
            }
            exchange.sendResponseBinary(bytesToWrite);
            throw new AbortException();
        }
        if (reset.booleanValue()) {
            context.clearBuffer();
        }
        if (body != null && (bodyResult = this.processBody(context, body)).isEarlyExit()) {
            return bodyResult;
        }
        return DEFAULT_RETURN;
    }
}

