/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.components;

import java.util.Set;
import ortus.boxlang.runtime.components.Attribute;
import ortus.boxlang.runtime.components.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCasterStrict;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validator;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.BoxCookie;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.util.KeyDictionary;

@BoxComponent
public class Cookie
extends Component {
    public Cookie() {
        this.declaredAttributes = new Attribute[]{new Attribute(Key._NAME, "string", Set.of(Validator.REQUIRED, Validator.NON_EMPTY)), new Attribute(Key.value, "string", (Object)""), new Attribute(Key.secure, "boolean"), new Attribute(Key.httpOnly, "boolean"), new Attribute(Key.expires, "any"), new Attribute(Key.samesite, "string"), new Attribute(Key.path, "string"), new Attribute(Key.domain, "string"), new Attribute(KeyDictionary.encodevalue, "boolean", (Object)true)};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component.BodyResult _invoke(IBoxContext context, IStruct attributes, Component.ComponentBody body, IStruct executionState) {
        String name = attributes.getAsString(Key._NAME);
        String value = attributes.getAsString(Key.value);
        Boolean secure = attributes.getAsBoolean(Key.secure);
        Boolean httpOnly = attributes.getAsBoolean(Key.httpOnly);
        Object expires = attributes.get((Object)Key.expires);
        String samesite = attributes.getAsString(Key.samesite);
        String path = attributes.getAsString(Key.path);
        String domain = attributes.getAsString(Key.domain);
        Boolean encodeValue = attributes.getAsBoolean(KeyDictionary.encodevalue);
        WebRequestBoxContext requestContext = (WebRequestBoxContext)((Object)context.getParentOfType(WebRequestBoxContext.class));
        IBoxHTTPExchange exchange = requestContext.getHTTPExchange();
        BoxCookie cookieInstance = new BoxCookie(name, value, encodeValue);
        if (secure != null) {
            cookieInstance.setSecure(secure);
        }
        if (httpOnly != null) {
            cookieInstance.setHttpOnly(httpOnly);
        }
        if (expires != null) {
            CastAttempt numberAttempt = NumberCaster.attempt((Object)expires, (boolean)false);
            if (numberAttempt.wasSuccessful()) {
                cookieInstance.setMaxAge((int)(((Number)numberAttempt.get()).doubleValue() * 24.0 * 60.0 * 60.0));
            } else {
                CastAttempt stringAttempt = StringCasterStrict.attempt((Object)expires);
                if (stringAttempt.wasSuccessful()) {
                    String stringValue = (String)stringAttempt.get();
                    if (stringValue.equalsIgnoreCase("now")) {
                        cookieInstance.setMaxAge(0);
                    } else {
                        if (!stringValue.equalsIgnoreCase("never")) throw new BoxValidationException("Invalid cookie expiration string value: " + stringValue);
                        cookieInstance.setMaxAge(946080000);
                    }
                } else {
                    CastAttempt dateAttempt = DateTimeCaster.attempt((Object)expires);
                    if (!dateAttempt.wasSuccessful()) throw new BoxValidationException("Invalid cookie expiration type: " + expires.getClass().getName());
                    cookieInstance.setExpires(((DateTime)dateAttempt.get()).toDate());
                }
            }
        }
        if (samesite != null) {
            cookieInstance.setSameSiteMode(samesite);
        }
        if (path != null) {
            cookieInstance.setPath(path);
        }
        if (domain != null) {
            cookieInstance.setDomain(domain);
        }
        exchange.addResponseCookie(cookieInstance);
        requestContext.getCookieScope().put(name, (Object)value);
        return DEFAULT_RETURN;
    }
}

