/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.context;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;
import ortus.boxlang.web.exchange.BoxCookie;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.scopes.CGIScope;
import ortus.boxlang.web.scopes.CookieScope;
import ortus.boxlang.web.scopes.FormScope;
import ortus.boxlang.web.scopes.RequestScope;
import ortus.boxlang.web.scopes.URLScope;
import ortus.boxlang.web.util.KeyDictionary;

public class WebRequestBoxContext
extends RequestBoxContext {
    private static BoxRuntime runtime = BoxRuntime.getInstance();
    protected IScope variablesScope = new VariablesScope();
    protected IScope requestScope;
    protected IScope URLScope;
    protected IScope formScope;
    protected IScope CGIScope;
    protected IScope cookieScope;
    protected IBoxHTTPExchange httpExchange;
    protected Object requestBody = null;
    protected String webRoot;
    protected Key sessionID = null;
    protected IStruct appSettings;
    protected IStruct sessionCookieDefaults = Struct.of((Object[])new Object[]{Key._NAME, "jsessionid", KeyDictionary.secure, false, KeyDictionary.httpOnly, true, KeyDictionary.disableUpdate, false, Key.timeout, new DateTime().modify("yyyy", Long.valueOf(30L)), KeyDictionary.sameSiteMode, "Lax"});

    public WebRequestBoxContext(IBoxContext parent, IBoxHTTPExchange httpExchange, String webRoot, URI template) {
        super(parent);
        httpExchange.setWebContext(this);
        this.httpExchange = httpExchange;
        this.webRoot = webRoot;
        this.URLScope = new URLScope(httpExchange);
        this.formScope = new FormScope(httpExchange);
        this.CGIScope = new CGIScope(httpExchange);
        this.cookieScope = new CookieScope(httpExchange);
        this.requestScope = new RequestScope(httpExchange);
    }

    public WebRequestBoxContext(IBoxContext parent, IBoxHTTPExchange exchange, String webRoot) {
        this(parent, exchange, webRoot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getSessionID() {
        IStruct appSettings = this.getConfig().getAsStruct(Key.applicationSettings);
        appSettings.putIfAbsent(KeyDictionary.sessionCookie, (Object)new Struct());
        IStruct sessionCookieSettings = appSettings.getAsStruct(KeyDictionary.sessionCookie);
        this.sessionCookieDefaults.entrySet().stream().forEach(entry -> sessionCookieSettings.putIfAbsent((Key)entry.getKey(), entry.getValue()));
        if (this.sessionID == null) {
            WebRequestBoxContext webRequestBoxContext = this;
            synchronized (webRequestBoxContext) {
                if (this.sessionID == null) {
                    BoxCookie sessionCookie = this.httpExchange.getRequestCookie(this.sessionCookieDefaults.getAsString(Key._NAME));
                    if (sessionCookie != null) {
                        this.sessionID = Key.of((String)sessionCookie.getValue());
                    } else {
                        Object expiration;
                        this.sessionID = Key.of((String)UUID.randomUUID().toString());
                        sessionCookie = new BoxCookie(this.sessionCookieDefaults.getAsString(Key._NAME), this.sessionID.getName()).setPath("/").setHttpOnly(sessionCookieSettings.getAsBoolean(KeyDictionary.httpOnly)).setSecure(sessionCookieSettings.getAsBoolean(Key.secure)).setDomain(sessionCookieSettings.getAsString(Key.domain)).setSameSiteMode(sessionCookieSettings.getAsString(KeyDictionary.sameSiteMode));
                        if (sessionCookieSettings.getAsBoolean(KeyDictionary.sameSite) != null) {
                            sessionCookie.setSameSite(sessionCookieSettings.getAsBoolean(KeyDictionary.sameSite));
                        }
                        if ((expiration = sessionCookieSettings.get((Object)Key.timeout)) instanceof DateTime) {
                            DateTime expireDateTime = (DateTime)expiration;
                            sessionCookie.setExpires(Date.from(expireDateTime.toInstant()));
                        } else if (expiration instanceof Duration) {
                            Duration expireDuration = (Duration)expiration;
                            sessionCookie.setExpires(Date.from(Instant.now().plus(expireDuration)));
                        } else {
                            sessionCookie.setExpires(Date.from(this.sessionCookieDefaults.getAsDateTime(Key.timeout).toInstant()));
                        }
                        this.httpExchange.addResponseCookie(sessionCookie);
                    }
                }
            }
        }
        return this.sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSession() {
        WebRequestBoxContext webRequestBoxContext = this;
        synchronized (webRequestBoxContext) {
            this.sessionID = null;
            this.httpExchange.addResponseCookie(new BoxCookie(this.sessionCookieDefaults.getAsString(Key._NAME), null));
            this.getApplicationListener().invalidateSession(this.getSessionID());
        }
    }

    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        scopes.getAsStruct(Key.contextual).put(ortus.boxlang.web.scopes.URLScope.name, (Object)this.URLScope);
        scopes.getAsStruct(Key.contextual).put(FormScope.name, (Object)this.formScope);
        scopes.getAsStruct(Key.contextual).put(ortus.boxlang.web.scopes.CGIScope.name, (Object)this.CGIScope);
        scopes.getAsStruct(Key.contextual).put(CookieScope.name, (Object)this.cookieScope);
        scopes.getAsStruct(Key.contextual).put(RequestScope.name, (Object)this.requestScope);
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
        }
        return scopes;
    }

    public boolean isKeyVisibleScope(Key key, boolean nearby, boolean shallow) {
        if (key.equals((Object)this.URLScope.getName()) || key.equals((Object)this.formScope.getName()) || key.equals((Object)this.CGIScope.getName()) || key.equals((Object)this.cookieScope.getName()) || key.equals((Object)this.requestScope.getName())) {
            return true;
        }
        if (nearby && key.equals((Object)VariablesScope.name)) {
            return true;
        }
        return super.isKeyVisibleScope(key, false, false);
    }

    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow, boolean forAssign) {
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        Object result = this.variablesScope.getRaw(key);
        if (this.isDefined(result, forAssign)) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.variablesScope, Struct.unWrapNull((Object)result), key);
        }
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope, forAssign);
    }

    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope, boolean forAssign) {
        if (key.equals((Object)this.requestScope.getName())) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.requestScope, (Object)this.requestScope, key, true);
        }
        if (key.equals((Object)this.CGIScope.getName())) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.CGIScope, (Object)this.CGIScope, key, true);
        }
        if (key.equals((Object)this.URLScope.getName())) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.URLScope, (Object)this.URLScope, key, true);
        }
        if (key.equals((Object)this.formScope.getName())) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.formScope, (Object)this.formScope, key, true);
        }
        if (key.equals((Object)this.cookieScope.getName())) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.cookieScope, (Object)this.cookieScope, key, true);
        }
        Object result = this.CGIScope.getRaw(key);
        if (this.isDefined(result, forAssign)) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.CGIScope, Struct.unWrapNull((Object)result), key);
        }
        result = this.URLScope.getRaw(key);
        if (this.isDefined(result, forAssign)) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.URLScope, Struct.unWrapNull((Object)result), key);
        }
        result = this.formScope.getRaw(key);
        if (this.isDefined(result, forAssign)) {
            return new IBoxContext.ScopeSearchResult((IReferenceable)this.formScope, Struct.unWrapNull((Object)result), key);
        }
        return super.scopeFind(key, defaultScope, forAssign);
    }

    public IScope getScope(Key name) throws ScopeNotFoundException {
        if (name.equals((Object)this.requestScope.getName())) {
            return this.requestScope;
        }
        if (name.equals((Object)this.URLScope.getName())) {
            return this.URLScope;
        }
        if (name.equals((Object)this.formScope.getName())) {
            return this.formScope;
        }
        if (name.equals((Object)this.CGIScope.getName())) {
            return this.CGIScope;
        }
        if (name.equals((Object)this.cookieScope.getName())) {
            return this.cookieScope;
        }
        if (this.parent != null) {
            return this.parent.getScope(name);
        }
        throw new ScopeNotFoundException(String.format("The requested scope name [%s] was not located in any context", name.getName()));
    }

    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals((Object)this.variablesScope.getName())) {
            return this.variablesScope;
        }
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }

    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.variablesScope, udf, override);
    }

    public IScope getDefaultAssignmentScope() {
        return this.variablesScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBoxContext flushBuffer(boolean force) {
        if (!this.canOutput().booleanValue() && !force) {
            return this;
        }
        if (force) {
            String output = "";
            Iterator iterator = this.buffers.iterator();
            while (iterator.hasNext()) {
                StringBuffer buf;
                StringBuffer stringBuffer = buf = (StringBuffer)iterator.next();
                synchronized (stringBuffer) {
                    output = output.concat(buf.toString());
                    buf.setLength(0);
                }
            }
            this.httpExchange.ensureResponseContentType();
            this.httpExchange.getResponseWriter().write(output);
            this.httpExchange.flushResponseBuffer();
        }
        return this;
    }

    public IBoxHTTPExchange getHTTPExchange() {
        return this.httpExchange;
    }

    public void setHTTPExchange(IBoxHTTPExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRequestBody() {
        if (this.requestBody != null) {
            return this.requestBody;
        }
        IBoxHTTPExchange iBoxHTTPExchange = this.httpExchange;
        synchronized (iBoxHTTPExchange) {
            if (this.requestBody != null) {
                return this.requestBody;
            }
            this.requestBody = this.httpExchange.getRequestBody();
        }
        return this.requestBody;
    }

    public IStruct getConfig() {
        IStruct config = super.getConfig();
        IStruct appMappings = this.getApplicationListener().getSettings().getAsStruct(Key.mappings);
        if (appMappings == null || appMappings.get((Object)Key._slash) == null) {
            config.getAsStruct(Key.mappings).put(Key._slash, (Object)this.webRoot);
        }
        return config;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public IScope getCookieScope() {
        return this.cookieScope;
    }

    public boolean isWhitespaceCompressionEnabled() {
        IStruct config = this.getConfig();
        if (!BooleanCaster.cast((Object)config.getOrDefault(Key.whitespaceCompressionEnabled, (Object)true)).booleanValue()) {
            return false;
        }
        String contentTypeHeader = this.httpExchange.getResponseHeader("Content-Type");
        return contentTypeHeader != null && contentTypeHeader.startsWith("text/html");
    }
}

