/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.exchange;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import ortus.boxlang.web.exchange.CookieSameSiteMode;

public class BoxCookie {
    private final String name;
    private String value;
    private String path;
    private String domain;
    private Integer maxAge;
    private Date expires;
    private boolean discard;
    private boolean secure;
    private boolean httpOnly;
    private int version = 1;
    private String comment;
    private boolean sameSite;
    private String sameSiteMode;
    private boolean encodeValue;

    public BoxCookie(String name, String value) {
        this(name, value, true);
    }

    public BoxCookie(String name, String value, Boolean encodeValue) {
        this.name = name;
        this.value = value;
        this.encodeValue = encodeValue;
    }

    public BoxCookie(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getEncodedValue() {
        if (this.encodeValue && this.value != null) {
            return URLEncoder.encode(this.value, StandardCharsets.UTF_8);
        }
        return this.value;
    }

    public BoxCookie setValue(String value) {
        this.value = value;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public BoxCookie setPath(String path) {
        this.path = path;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public BoxCookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public BoxCookie setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public boolean isDiscard() {
        return this.discard;
    }

    public BoxCookie setDiscard(boolean discard) {
        this.discard = discard;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public BoxCookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public BoxCookie setVersion(int version) {
        this.version = version;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public BoxCookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public Date getExpires() {
        return this.expires;
    }

    public BoxCookie setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public BoxCookie setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public boolean isSameSite() {
        return this.sameSite;
    }

    public BoxCookie setSameSite(boolean sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    public String getSameSiteMode() {
        return this.sameSiteMode;
    }

    public BoxCookie setSameSiteMode(String mode) {
        if (mode == null) {
            return this;
        }
        String m = CookieSameSiteMode.lookupModeString(mode);
        if (m != null) {
            this.sameSiteMode = m;
            this.setSameSite(true);
        } else {
            System.out.println("Ignoring invalid cookie same site mode: " + mode);
        }
        return this;
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 37 * result + (this.getPath() == null ? 0 : this.getPath().hashCode());
        result = 37 * result + (this.getDomain() == null ? 0 : this.getDomain().hashCode());
        return result;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BoxCookie)) {
            return false;
        }
        BoxCookie o = (BoxCookie)other;
        if (this.getName() == null && o.getName() != null) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(o.getName())) {
            return false;
        }
        if (this.getPath() == null && o.getPath() != null) {
            return false;
        }
        if (this.getPath() != null && !this.getPath().equals(o.getPath())) {
            return false;
        }
        if (this.getDomain() == null && o.getDomain() != null) {
            return false;
        }
        return this.getDomain() == null || this.getDomain().equals(o.getDomain());
    }

    public final String toString() {
        return "{BoxCookie@" + System.identityHashCode(this) + " name=" + this.getName() + " path=" + this.getPath() + " domain=" + this.getDomain() + " value=" + this.getValue() + " secure=" + this.isSecure() + " httpOnly=" + this.isHttpOnly() + " expires=" + String.valueOf(this.getExpires()) + " maxAge=" + this.getMaxAge() + " discard=" + this.isDiscard() + " version=" + this.getVersion() + " comment=" + this.getComment() + " sameSite=" + this.isSameSite() + " sameSiteMode=" + this.getSameSiteMode() + "}";
    }

    public static BoxCookie fromEncoded(String name, String value) {
        try {
            if (value != null) {
                value = URLDecoder.decode(value, StandardCharsets.UTF_8);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("IllegalArgumentException decoding cookie name: [" + name + "] value: [" + value + "] error: " + e.getMessage());
        }
        return new BoxCookie(name, value);
    }

    public String toSetCookieHeader() {
        StringBuilder header = new StringBuilder();
        header.append(this.getName()).append("=").append(this.getEncodedValue()).append("; ");
        if (this.getPath() != null) {
            header.append("Path=").append(this.getPath()).append("; ");
        }
        if (this.getDomain() != null) {
            header.append("Domain=").append(this.getDomain()).append("; ");
        }
        if (this.getMaxAge() != null) {
            header.append("Max-Age=").append(this.getMaxAge()).append("; ");
        }
        if (this.getExpires() != null) {
            header.append("Expires=").append(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(this.getExpires())).append("; ");
        }
        if (this.isSecure()) {
            header.append("Secure; ");
        }
        if (this.isHttpOnly()) {
            header.append("HttpOnly; ");
        }
        if (this.isSameSite() && this.getSameSiteMode() != null) {
            header.append("SameSite=").append(this.getSameSiteMode()).append("; ");
        }
        if (header.length() > 2 && header.substring(header.length() - 2).equals("; ")) {
            header.setLength(header.length() - 2);
        }
        return header.toString();
    }
}

