/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.exchange;

import java.io.PrintWriter;
import java.io.Writer;

public class WhitespaceManagingPrintWriter
extends PrintWriter {
    private boolean enable = true;
    private boolean preserveWhitespace = false;
    private StringBuilder tagBuffer = new StringBuilder();
    private boolean inTag = false;
    private boolean closeTag = false;
    private boolean firstTagChar = true;
    private boolean previousCharWasWhitespace = false;

    public WhitespaceManagingPrintWriter(Writer out, boolean enable) {
        super(out);
        this.enable = enable;
    }

    @Override
    public void write(int c) {
        this.processChar((char)c);
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.processChar(buf[i]);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.processChar(s.charAt(i));
        }
    }

    private void processChar(char ch) {
        if (!this.enable) {
            super.write(ch);
            return;
        }
        boolean isWS = Character.isWhitespace(ch);
        if (this.inTag) {
            if (this.firstTagChar && ch == '/') {
                this.closeTag = true;
                super.write(ch);
                this.previousCharWasWhitespace = isWS;
                return;
            }
            if (this.firstTagChar && !isWS && ch != '>' && ch != 'p' && ch != 'c' && ch != 't') {
                this.inTag = false;
                super.write(ch);
                this.previousCharWasWhitespace = isWS;
                return;
            }
            if (!isWS && ch != '>') {
                this.tagBuffer.append(Character.toLowerCase(ch));
            }
            this.firstTagChar = false;
            if (isWS || ch == '>') {
                String tagName = this.tagBuffer.toString();
                if ("pre".equals(tagName) || "code".equals(tagName) || "textarea".equals(tagName)) {
                    this.preserveWhitespace = !this.closeTag;
                }
                this.inTag = false;
            }
            super.write(ch);
        } else {
            if (ch == '<') {
                this.inTag = true;
                this.closeTag = false;
                this.firstTagChar = true;
                this.tagBuffer.setLength(0);
                super.write(ch);
                this.previousCharWasWhitespace = isWS;
                return;
            }
            if (!this.preserveWhitespace && isWS && this.previousCharWasWhitespace) {
                this.previousCharWasWhitespace = isWS;
                return;
            }
            super.write(ch);
        }
        this.previousCharWasWhitespace = isWS;
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Override
    public void close() {
        this.flush();
        super.close();
    }

    public boolean isWhitespaceCompressionEnabled() {
        return this.enable;
    }

    public void setWhitespaceCompressionEnabled(boolean enable) {
        this.enable = enable;
    }
}

