/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.interceptors;

import java.util.Map;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.components.cache.Cache;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.events.BaseInterceptor;
import ortus.boxlang.runtime.events.InterceptionPoint;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.ComponentService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbortException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.util.KeyDictionary;

public class WebRequest
extends BaseInterceptor {
    protected BoxRuntime runtime = BoxRuntime.getInstance();
    protected ComponentService componentService = BoxRuntime.getInstance().getComponentService();

    @InterceptionPoint
    public void writeToBrowser(IStruct data) {
        byte[] contentBytes;
        String disposition = "inline";
        IBoxContext context = (IBoxContext)data.get((Object)Key.context);
        if (context == null) {
            throw new BoxRuntimeException("A context is required in the intercept data in order to announce this interception");
        }
        Object content = data.get((Object)Key.content);
        if (content == null) {
            throw new BoxRuntimeException("A request to write to the browser was announced, but no content to write was provided.");
        }
        WebRequestBoxContext requestContext = (WebRequestBoxContext)((Object)context.getParentOfType(WebRequestBoxContext.class));
        IBoxHTTPExchange exchange = requestContext.getHTTPExchange();
        String fileName = data.getAsString(KeyDictionary.fileName);
        if (fileName != null) {
            disposition = "attachment";
        }
        String mimeType = StringCaster.cast((Object)data.getOrDefault(Key.mimetype, (Object)"text/html"));
        Boolean reset = BooleanCaster.cast((Object)data.getOrDefault(Key.reset, (Object)false));
        Boolean abort = BooleanCaster.cast((Object)data.getOrDefault(Key.abort, (Object)false));
        if (reset.booleanValue()) {
            context.clearBuffer();
        }
        if (content instanceof byte[]) {
            byte[] barr = (byte[])content;
            contentBytes = barr;
        } else {
            contentBytes = StringCaster.cast((Object)content).getBytes();
        }
        exchange.setResponseHeader("content-type", mimeType);
        if (disposition == "attachment") {
            exchange.setResponseHeader("content-disposition", disposition + "; filename=" + fileName);
        }
        exchange.sendResponseBinary(contentBytes);
        if (abort.booleanValue()) {
            throw new AbortException();
        }
        data.put(KeyDictionary.success, (Object)true);
    }

    @InterceptionPoint
    public void onFileComponentAction(IStruct data) {
        IStruct attributes = data.getAsStruct(Key.attributes);
        Key action = Key.of((String)attributes.getAsString(Key.action));
        if (!action.equals((Object)KeyDictionary.upload) && !action.equals((Object)KeyDictionary.uploadAll)) {
            return;
        }
        IBoxContext context = (IBoxContext)data.get((Object)Key.context);
        Key BIFMethod = null;
        BIFMethod = action.equals((Object)KeyDictionary.upload) ? KeyDictionary.fileUpload : KeyDictionary.fileUploadAll;
        attributes.put(BIF.__functionName, (Object)BIFMethod);
        data.put(Key.response, this.runtime.getFunctionService().getGlobalFunction(BIFMethod).invoke(context, (Map)attributes, false, BIFMethod));
    }

    @InterceptionPoint
    public void onComponentInvocation(IStruct data) {
        Component component = (Component)data.get((Object)Key.component);
        if (component == null || data.get((Object)Key.result) != null) {
            return;
        }
        if (component instanceof Cache) {
            IBoxContext context = (IBoxContext)data.get((Object)Key.context);
            IStruct attributes = data.getAsStruct(Key.attributes);
            Component.ComponentBody body = (Component.ComponentBody)data.get((Object)Key.body);
            Cache.CacheAction cacheAction = Cache.CacheAction.fromString((String)attributes.getAsString(Key.action));
            Double timespan = attributes.getAsDouble(Key.timespan);
            if (context.getParentOfType(WebRequestBoxContext.class) == null) {
                throw new BoxRuntimeException(String.format("The specified cache action [%s] is is not valid in a non-web runtime", cacheAction.toString().toLowerCase()));
            }
            String cacheDirective = null;
            if (cacheAction.equals((Object)Cache.CacheAction.SERVERCACHE)) {
                cacheDirective = timespan == null ? "server" : "s-max-age=" + DoubleCaster.cast((Object)(timespan * 86400.0)).intValue();
            } else if (cacheAction.equals((Object)Cache.CacheAction.CLIENTCACHE)) {
                String string = cacheDirective = timespan == null ? "private" : "max-age=" + DoubleCaster.cast((Object)(timespan * 86400.0)).intValue();
            }
            if (cacheDirective != null) {
                this.componentService.getComponent(Key.header).invoke(context, Struct.of((Object[])new Object[]{Key._NAME, "Cache-Control", Key.value, cacheDirective}), body);
                data.put(Key.result, (Object)cacheDirective);
            }
        }
    }
}

