/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.scopes;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.BaseScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.web.context.WebRequestBoxContext;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;
import ortus.boxlang.web.util.KeyDictionary;

public class CGIScope
extends BaseScope {
    private Set<Key> knownKeys = new TreeSet<Key>(Arrays.asList(Key.auth_password, Key.auth_type, Key.auth_user, KeyDictionary.bx_template_path, Key.cert_cookie, Key.cert_flags, Key.cert_issuer, Key.cert_keysize, Key.cert_secretkeysize, Key.cert_serialnumber, Key.cert_server_issuer, Key.cert_server_subject, Key.cert_subject, Key.cf_template_path, Key.content_length, Key.content_type, Key.context_path, Key.gateway_interface, Key.http_accept_encoding, Key.http_accept_language, Key.http_accept, Key.http_connection, Key.http_cookie, Key.http_host, Key.http_referer, Key.http_user_agent, Key.https_keysize, Key.https_secretkeysize, Key.https_server_issuer, Key.https_server_subject, Key.https, Key.local_addr, Key.local_host, Key.path_info, Key.path_translated, Key.query_string, Key.remote_addr, Key.remote_host, Key.remote_user, Key.request_method, Key.request_url, Key.script_name, Key.server_name, Key.server_port_secure, Key.server_port, Key.server_protocol, Key.server_software, Key.web_server_api));
    public static final Key name = Key.of((String)"cgi");
    protected IBoxHTTPExchange exchange;

    public CGIScope(IBoxHTTPExchange exchange) {
        super(name);
        this.exchange = exchange;
    }

    private String getTemplatePath(IBoxContext context) {
        WebRequestBoxContext webContext = (WebRequestBoxContext)((Object)context.getParentOfType(WebRequestBoxContext.class));
        String requestURI = this.exchange.getRequestURI();
        if (requestURI == null) {
            return "";
        }
        return Path.of(webContext.getWebRoot() + requestURI, new String[0]).toAbsolutePath().toString();
    }

    public Object dereference(IBoxContext context, Key key, Boolean safe) {
        if (key.equals((Object)BoxMeta.key)) {
            return this.getBoxMeta();
        }
        Object value = this.getRaw(key);
        if (value == null) {
            return "";
        }
        return this.unWrapNullInternal(value);
    }

    public Object get(String key) {
        Key keyObj = Key.of((String)key);
        return this.unWrapNullInternal(this.getRaw(keyObj));
    }

    public Object getRaw(Key key) {
        Object value = this.wrapped.get(key);
        if (value != null) {
            return value;
        }
        if (key.equals((Object)Key.content_type)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestHeader("Content-Type")));
        }
        if (key.equals((Object)Key.content_length)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestContentLength()));
        }
        if (key.equals((Object)Key.cf_template_path) || key.equals((Object)KeyDictionary.bx_template_path) || key.equals((Object)Key.path_translated)) {
            return this.putAndReturn(key, this.defaultNullToString(this.getTemplatePath((IBoxContext)this.exchange.getWebContext())));
        }
        if (key.equals((Object)Key.https)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.isRequestSecure()));
        }
        if (key.equals((Object)Key.http_host)) {
            int port = this.exchange.getRequestServerPort();
            return this.putAndReturn(key, port == 80 || port == 443 ? this.exchange.getRequestServerName() : this.exchange.getRequestServerName() + ":" + String.valueOf(this.defaultNullToString(port)));
        }
        if (key.equals((Object)Key.local_addr)) {
            try {
                return this.putAndReturn(key, this.defaultNullToString(InetAddress.getLocalHost().getHostAddress()));
            }
            catch (UnknownHostException e) {
                return this.putAndReturn(key, "127.0.0.1");
            }
        }
        if (key.equals((Object)Key.local_host)) {
            try {
                return this.putAndReturn(key, this.defaultNullToString(InetAddress.getLocalHost().getHostName()));
            }
            catch (UnknownHostException e) {
                return this.putAndReturn(key, "localhost");
            }
        }
        if (key.equals((Object)Key.request_url)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestURL()));
        }
        if (key.equals((Object)Key.remote_addr)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestRemoteAddr()));
        }
        if (key.equals((Object)Key.remote_host)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestRemoteHost()));
        }
        if (key.equals((Object)Key.remote_user)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestRemoteUser()));
        }
        if (key.equals((Object)Key.path_info)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestPathInfo()));
        }
        if (key.equals((Object)Key.query_string)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestQueryString()));
        }
        if (key.equals((Object)Key.request_method)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestMethod()));
        }
        if (key.equals((Object)Key.script_name)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestURI()));
        }
        if (key.equals((Object)Key.server_name)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestServerName()));
        }
        if (key.equals((Object)Key.server_port)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestServerPort()));
        }
        if (key.equals((Object)Key.server_port_secure)) {
            return this.putAndReturn(key, this.exchange.isRequestSecure() ? this.defaultNullToString(this.exchange.getRequestServerPort()) : Integer.valueOf(0));
        }
        if (key.equals((Object)Key.server_protocol)) {
            return this.putAndReturn(key, this.defaultNullToString(this.exchange.getRequestProtocol()));
        }
        String header = this.exchange.getRequestHeader(key.getName());
        if (header != null) {
            return this.putAndReturn(key, header);
        }
        if (key.getName().toLowerCase().startsWith("http_") && key.getName().length() > 5 && (header = this.exchange.getRequestHeader(key.getName().substring(5).replace("_", "-"))) != null) {
            return this.putAndReturn(key, header);
        }
        return null;
    }

    public Set<Map.Entry<Key, Object>> entrySet() {
        LinkedHashSet<Key> allKeys = new LinkedHashSet<Key>(this.knownKeys);
        allKeys.addAll(this.wrapped.keySet());
        return allKeys.stream().map(key -> new AbstractMap.SimpleEntry<Key, Object>((Key)key, this.unWrapNullInternal(this.getRaw((Key)key)))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Key> getDumpKeys() {
        return this.knownKeys;
    }

    public Set<String> getDumpKeysAsString() {
        return this.knownKeys.stream().map(Key::getName).collect(TreeSet::new, Set::add, Set::addAll);
    }

    public Set<Key> keySet() {
        return this.knownKeys;
    }

    public int size() {
        return this.knownKeys.size();
    }

    public boolean containsKey(Key key) {
        return this.knownKeys.contains(key) ? true : this.wrapped.containsKey(key);
    }

    private Object defaultNullToString(Object value) {
        return value == null ? "" : value;
    }

    private Object putAndReturn(Key key, Object value) {
        this.wrapped.put(key, this.wrapNull(value));
        return value;
    }
}

