/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.web.scopes;

import java.util.Date;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.BaseScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.web.exchange.BoxCookie;
import ortus.boxlang.web.exchange.IBoxHTTPExchange;

public class CookieScope
extends BaseScope {
    public static final Key name = Key.of((String)"cookie");
    private static final Key maxAgeKey = Key.of((String)"maxAge");
    private static final Key sameSiteKey = Key.of((String)"sameSite");
    private static final Key sameSiteModeKey = Key.of((String)"sameSiteMode");
    protected IBoxHTTPExchange exchange;

    public CookieScope(IBoxHTTPExchange exchange) {
        super(name);
        this.exchange = exchange;
        for (BoxCookie cookie : exchange.getRequestCookies()) {
            this.put(Key.of((String)cookie.getName()), cookie.getValue());
        }
    }

    public Object assign(IBoxContext context, Key key, Object value) {
        CastAttempt structAttempt = StructCaster.attempt((Object)value);
        String cookieValue = "";
        String path = "/";
        String domain = null;
        Integer maxAge = null;
        Date expires = null;
        boolean secure = false;
        boolean httpOnly = false;
        int version = 0;
        boolean sameSite = false;
        String sameSiteMode = null;
        if (structAttempt.wasSuccessful()) {
            IStruct cookieData = (IStruct)structAttempt.get();
            if (cookieData.containsKey(Key.value)) {
                cookieValue = StringCaster.cast((Object)cookieData.get((Object)Key.value));
            }
            if (cookieData.containsKey(Key.path)) {
                path = StringCaster.cast((Object)cookieData.get((Object)Key.path));
            }
            if (cookieData.containsKey(Key.domain)) {
                domain = StringCaster.cast((Object)cookieData.get((Object)Key.domain));
            }
            if (cookieData.containsKey(maxAgeKey)) {
                maxAge = IntegerCaster.cast((Object)cookieData.get((Object)maxAgeKey));
            }
            if (cookieData.containsKey(Key.expires)) {
                expires = Date.from(DateTimeCaster.cast((Object)cookieData.get((Object)Key.expires)).toInstant());
            }
            if (cookieData.containsKey(Key.secure)) {
                secure = BooleanCaster.cast((Object)cookieData.get((Object)Key.secure));
            }
            if (cookieData.containsKey(Key.httpOnly)) {
                httpOnly = BooleanCaster.cast((Object)cookieData.get((Object)Key.httpOnly));
            }
            if (cookieData.containsKey(Key.version)) {
                version = IntegerCaster.cast((Object)cookieData.get((Object)Key.version));
            }
            if (cookieData.containsKey(sameSiteKey)) {
                sameSite = BooleanCaster.cast((Object)cookieData.get((Object)sameSiteKey));
            }
            if (cookieData.containsKey(sameSiteModeKey)) {
                sameSiteMode = StringCaster.cast((Object)cookieData.get((Object)sameSiteModeKey));
            }
        } else {
            cookieValue = StringCaster.cast((Object)value);
        }
        this.put(key, cookieValue);
        this.exchange.addResponseCookie(new BoxCookie(key.getName(), cookieValue).setPath(path).setDomain(domain).setMaxAge(maxAge).setSecure(secure).setVersion(version).setHttpOnly(httpOnly).setExpires(expires).setSameSite(sameSite).setSameSiteMode(sameSiteMode));
        return value;
    }
}

