package io.boxo

import android.annotation.SuppressLint
import android.app.Application
import android.content.Context
import io.boxo.data.network.NetworkService
import io.boxo.data.storage.BoxoPermissions
import io.boxo.data.storage.BoxoStorage
import io.boxo.data.storage.IBoxoPermissions
import io.boxo.data.storage.IBoxoStorage
import io.boxo.js.JSFunctions
import io.boxo.log.DefaultLogger
import io.boxo.log.InternalLogger
import io.boxo.sdk.Boxo
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import java.util.concurrent.TimeUnit

@SuppressLint("StaticFieldLeak")
internal object ServiceLocator {

    lateinit var context: Context

    private val okhttpClient by lazy {
        OkHttpClient.Builder()
            .callTimeout(1, TimeUnit.MINUTES)
            .connectTimeout(1, TimeUnit.MINUTES)
            .readTimeout(1, TimeUnit.MINUTES)
            .writeTimeout(1, TimeUnit.MINUTES)
            .apply {
                if (BuildConfig.DEBUG)
                    addInterceptor(HttpLoggingInterceptor().apply {
                        level = HttpLoggingInterceptor.Level.BODY
                    })
            }
            .build()
    }
    internal val networkService
            by lazy { NetworkService(okhttpClient, Boxo, storage, BuildConfig.VERSION_NAME) }
    internal val storage: IBoxoStorage by lazy { BoxoStorage(context) }
    internal val permissions: IBoxoPermissions by lazy { BoxoPermissions(context) }
    internal val jsFunctions by lazy { JSFunctions(Boxo) }
    internal val logger by lazy { InternalLogger(DefaultLogger(true), networkService) }
    fun init(application: Application) {
        context = application
    }
}