package io.boxo.data.storage

import android.content.Context

internal class BoxoPermissions(context: Context) : IBoxoPermissions {
    private val sp = context.getSharedPreferences("BoxoSDK_Permissions", Context.MODE_PRIVATE)
    private val editor = sp.edit()

    override fun hasUserDataPermission(appId: String): Boolean {
        return sp.getBoolean("${appId}_has_user_info_permission", false)
    }

    override fun allowUserDataPermission(appId: String, allow: Boolean) {
        editor.putBoolean("${appId}_has_user_info_permission", allow).commit()
    }

    override fun hasLocationPermission(appId: String): Boolean {
        return sp.getBoolean("${appId}_has_location_permission", false)
    }

    override fun allowLocationPermission(appId: String, allow: Boolean) {
        editor.putBoolean("${appId}_has_location_permission", allow).commit()
    }

    override fun hasCameraPermission(appId: String): Boolean {
        return sp.getBoolean("${appId}_has_camera_permission", false)
    }

    override fun allowCameraPermission(appId: String, allow: Boolean) {
        editor.putBoolean("${appId}_has_camera_permission", allow).commit()
    }
}
