package io.boxo.data.storage

import android.content.Context
import io.boxo.data.models.MiniappSettings
import io.boxo.data.models.toMiniappSettings
import java.util.*

internal class BoxoStorage(context: Context) : IBoxoStorage {
    private val sp = context.getSharedPreferences("BoxoSDK_Main", Context.MODE_PRIVATE)
    private val editor = sp.edit()

    override val guid: String
        get() {
            var guid = sp.getString("guid", null)
            if (guid.isNullOrBlank()) {
                guid = UUID.randomUUID().toString()
                editor.putString("guid", guid).commit()
            }
            return guid
        }

    override fun saveMiniappSettings(appId: String, miniappSettings: MiniappSettings) {
        editor.putString("${appId}_miniapp_settings", miniappSettings.json)
            .putLong("${appId}_miniapp_settings_saved_time", System.currentTimeMillis())
            .commit()
    }

    override fun getMiniappSettings(appId: String): MiniappSettings? {
        return sp.getString("${appId}_miniapp_settings", null)?.toMiniappSettings()
    }

    override fun miniappSettingsSavedTime(appId: String): Long {
        return sp.getLong("${appId}_miniapp_settings_saved_time", 0)
    }

    override fun saveMiniappToken(appId: String, token: String) {
        editor.putString("${appId}_self_token", token).commit()
    }

    override fun getMiniappToken(appId: String): String? {
        return sp.getString("${appId}_self_token", null)
    }

    override fun isFirstLaunch(appId: String): Boolean {
        return sp.getBoolean("${appId}_is_first_launch", true)
    }

    override fun miniappLaunched(appId: String) {
        editor.putBoolean("${appId}_is_first_launch", false).commit()
    }

    override fun clearToken(appId: String) {
        editor.remove(appId + "_self_token").commit()
    }

    override fun clearMiniappData(appId: String?) {
        if (appId == null) return
        clearToken(appId)
        editor.remove("${appId}_last_state").commit()
    }

    override fun clearAll() {
        editor.clear().apply()
    }
}
