package io.boxo.data.storage

import io.boxo.data.models.MiniappSettings

internal interface IBoxoStorage {
    val guid: String
    fun saveMiniappSettings(appId: String, miniappSettings: MiniappSettings)
    fun getMiniappSettings(appId: String): MiniappSettings?
    fun miniappSettingsSavedTime(appId: String): Long
    fun saveMiniappToken(appId: String, token: String)
    fun getMiniappToken(appId: String): String?
    fun isFirstLaunch(appId: String): Boolean
    fun miniappLaunched(appId: String)
    fun clearToken(appId: String)
    fun clearAll()
    fun clearMiniappData(appId: String?)
}