package io.boxo.data.storage

import android.content.Context

internal class MiniappStorage(context: Context, appId: String) : IMiniappStorage {
    private val sp = context.getSharedPreferences("BoxoSDK_MiniApp_$appId", Context.MODE_PRIVATE)
    private val editor = sp.edit()

    override fun getKeys(count: Int, offset: Int): List<String> {
        val keys = sp.all.keys.toList()
        return if (count < keys.size && offset < count) keys.subList(offset, count - 1)
        else if (count < keys.size) keys.subList(0, count - 1)
        else keys
    }

    override fun set(key: String, value: Any) {
        editor.apply {
            when (value) {
                is String -> putString(key, value)
                is Int -> putInt(key, value)
                is Long -> putLong(key, value)
                is Boolean -> putBoolean(key, value)
                is Float -> putFloat(key, value)
                else -> putString(key, value.toString())
            }
        }.apply()
    }

    override fun get(keys: Array<String>): Map<String, *> {
        val values = mutableMapOf<String, Any?>()
        keys.forEach { key -> values[key] = get(key) }
        return values
    }

    private fun get(key: String): Any? {
        var value: Any? = null
        runCatching { sp.getBoolean(key, false) }.onSuccess { value = it }
        runCatching { sp.getFloat(key, 0.0f) }.onSuccess { value = it }
        runCatching { sp.getInt(key, 0) }.onSuccess { value = it }
        runCatching { sp.getLong(key, 0) }.onSuccess { value = it }
        runCatching { sp.getString(key, null) }.onSuccess { value = it }
        return value
    }

    override fun remove(key: String) {
        editor.remove(key).apply()
    }

    override fun clear() {
        editor.clear().apply()
    }
}