package io.boxo.events

import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import io.boxo.js.JSFunctions
import io.boxo.js.events.IClipboardEvents
import io.boxo.ui.main.BoxoActivity

internal class ClipboardEvents(
    private val activity: BoxoActivity,
    private val jsFunctions: JSFunctions,
    private val evaluateJavascript: (String) -> Unit
) : IClipboardEvents {
    private val clipboard by lazy { activity.getSystemService(Context.CLIPBOARD_SERVICE) as ClipboardManager }

    override fun setClipboard(requestId: String, data: String) {
        val clip = ClipData.newPlainText("BoxoSDK", data)
        clipboard.setPrimaryClip(clip)
        evaluateJavascript(jsFunctions.setClipboardSuccess(requestId))
    }

    override fun getClipboard(requestId: String) {
        val data = clipboard.primaryClip?.getItemAt(0)?.text.toString()
        evaluateJavascript(jsFunctions.getClipboard(requestId, data))
    }
}