package io.boxo.events

import io.boxo.data.storage.IMiniappStorage
import io.boxo.data.storage.MiniappStorage
import io.boxo.js.JSFunctions
import io.boxo.js.events.IStorageEvents
import io.boxo.ui.main.BoxoActivity
import io.boxo.ui.main.BoxoViewModel

internal class StorageEvents(
    private val activity: BoxoActivity,
    private val jsFunctions: JSFunctions,
    private val viewModel: BoxoViewModel,
    private val evaluateJavascript: (String) -> Unit
) : IStorageEvents {
    private val miniappStorage: IMiniappStorage by lazy { MiniappStorage(activity, viewModel.appId) }

    override fun storageGet(requestId: String, keys: Array<String>) {
        val result = miniappStorage.get(keys)
        evaluateJavascript(jsFunctions.storageGetResult(requestId, result))
    }

    override fun storageGetKeys(requestId: String, count: Int, offset: Int) {
        val keys = miniappStorage.getKeys(count, offset)
        evaluateJavascript(jsFunctions.storageGetKeysResult(requestId, keys))
    }

    override fun storageSet(requestId: String, key: String, value: Any) {
        miniappStorage.set(key, value)
        evaluateJavascript(jsFunctions.storageSuccessResult(requestId))
    }

    override fun storageRemove(requestId: String, key: String) {
        miniappStorage.remove(key)
        evaluateJavascript(jsFunctions.storageSuccessResult(requestId))
    }

    override fun storageClear(requestId: String) {
        miniappStorage.clear()
        evaluateJavascript(jsFunctions.storageSuccessResult(requestId))
    }
}