package io.boxo.events

import io.boxo.js.JSFunctions
import io.boxo.js.events.ITransactionEvents
import io.boxo.ui.main.BoxoViewModel

internal class TransactionEvents(
    private val viewModel: BoxoViewModel,
    private val jsFunctions: JSFunctions,
    private val evaluateJavascript: (String) -> Unit
) : ITransactionEvents {
    override fun transactionTrack(requestId: String, payload: String) {
        viewModel.transactionTrack(payload) { result ->
            evaluateJavascript(jsFunctions.transactionTrack(requestId, result))
        }
    }
}