package io.boxo.events

import android.content.Context
import android.os.Build
import android.os.VibrationEffect
import android.os.Vibrator
import io.boxo.js.events.IVibrationEvents
import io.boxo.js.params.HapticFeedback
import io.boxo.ui.main.BoxoActivity

internal class VibrationEvents(
    private val activity: BoxoActivity,
) : IVibrationEvents {

    private val vibrator by lazy { activity.getSystemService(Context.VIBRATOR_SERVICE) as? Vibrator }

    @Suppress("DEPRECATION")
    override fun vibrate(hapticFeedback: HapticFeedback) {
        val time = when (hapticFeedback.style) {
            HapticFeedback.Style.light -> 10L
            HapticFeedback.Style.medium -> 30L
            HapticFeedback.Style.heavy -> 50L
        }
        when {
            Build.VERSION.SDK_INT >= Build.VERSION_CODES.O ->
                vibrator?.vibrate(VibrationEffect.createOneShot(time, VibrationEffect.DEFAULT_AMPLITUDE))

            else -> vibrator?.vibrate(time)
        }
    }

}