package io.boxo.js.events

import io.boxo.js.params.ActionButton
import io.boxo.js.params.ActionSheet
import io.boxo.js.params.Alert
import io.boxo.js.params.NavigationBar
import io.boxo.js.params.PullToRefresh
import io.boxo.js.params.TabBar

internal interface IUIEvents {
    fun setTabBar(tabBar: TabBar)
    fun setNavigationBar(navigationBar: NavigationBar)
    fun setActionButtons(actionButton: ActionButton)
    fun setPullToRefresh(pullToRefresh: PullToRefresh)
    fun stopPullToRefresh()
    fun setBackgroundColor(color: String)
    fun setStatusBarColor(color: String)
    fun loadingIndicator(show: Boolean)
    fun showActionSheet(actionSheet: ActionSheet)
    fun showAlert(alert: Alert)
    fun showQrCodeReader()
    fun showGallery(images: List<String>)
}