package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.IAuthEvents
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class AuthJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: IAuthEvents,
    private val boxo: Boxo
) {
    fun login(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            val message = json.getString("confirmModalText")
            val requestedData = json.optJSONArray("requested_data")?.let {
                val list = mutableListOf<String>()
                for (i in 0..it.length())
                    list.add(it.getString(i))
                list
            } ?: emptyList()

            Triple(requestId, message, requestedData)
        }
            .onFailure { boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (requestId, message, requestedData) ->
                handler.post { events.login(requestId, message, requestedData) }
            }
    }

    fun logout(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("request_id")
        }
            .onFailure { boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { requestId -> handler.post { events.logout(requestId) } }
    }

}