package io.boxo.js.jsInterfaces

import android.webkit.JavascriptInterface

internal class BoxoJsInterface(
    private val uiJsI: UiJsI,
    private val miniappJsI: MiniappJsI,
    private val authJsI: AuthJsI,
    private val transactionJsI: TransactionJsI,
    private val customEventsJsI: CustomEventsJsI,
    private val clipboardJsI: ClipboardJsI,
    private val vibrationJsI: VibrationJsI,
    private val storageJsI: StorageJsI,
    private val locationJsI: LocationJsI,
    private val sensorJsI: SensorJsI,
    private val systemJsI: SystemJsI,
    private val paymentEventsJsI: PaymentEventsJsI
) {

    @JavascriptInterface
    fun AppBoxoWebAppGetMiniappSettings(body: String) = miniappJsI.getMiniappSettings(body)

    @JavascriptInterface
    fun AppBoxoWebAppGetInitData(body: String) = miniappJsI.getInitData(body)

    @JavascriptInterface
    fun AppBoxoWebAppCloseMiniApp(body: String) = miniappJsI.closeMiniapp(body)

    @JavascriptInterface
    fun AppBoxoWebAppOpenMiniApp(body: String) = miniappJsI.openMiniapp(body)

    @JavascriptInterface
    fun AppBoxoWebAppCustomEvent(body: String) = customEventsJsI.customEvent(body)

    @JavascriptInterface
    fun AppBoxoWebAppLogin(body: String) = authJsI.login(body)

    @JavascriptInterface
    fun AppBoxoWebAppLogout(body: String) = authJsI.logout(body)

    @JavascriptInterface
    fun AppBoxoWebAppPay(body: String) = paymentEventsJsI.paymentEvent(body)

    @JavascriptInterface
    fun AppBoxoWebAppTrack(body: String) = transactionJsI.transactionTrack(body)

    //region UI JS Interfaces
    @JavascriptInterface
    fun AppBoxoWebAppSetTabBar(body: String) = uiJsI.setTabBar(body)

    @JavascriptInterface
    fun AppBoxoWebAppSetNavigationBar(body: String) = uiJsI.setNavigationBar(body)

    @JavascriptInterface
    fun AppBoxoWebAppSetActionButton(body: String) = uiJsI.setActionButton(body)

    @JavascriptInterface
    fun AppBoxoWebAppLoadingIndicator(body: String) = uiJsI.loadingIndicator(body)

    @JavascriptInterface
    fun AppBoxoWebAppOpenQRCodeReader(body: String) = uiJsI.openQRCodeReader(body)

    @JavascriptInterface
    fun AppBoxoWebAppShowActionSheet(body: String) = uiJsI.showActionSheet(body)

    @JavascriptInterface
    fun AppBoxoWebAppShowAlert(body: String) = uiJsI.showAlert(body)

    @JavascriptInterface
    fun AppBoxoWebAppShowImages(body: String) = uiJsI.showImages(body)

    @JavascriptInterface
    fun AppBoxoWebAppSetBackgroundColor(body: String) = uiJsI.setBackgroundColor(body)

    @JavascriptInterface
    fun AppBoxoWebAppSetStatusBarColor(body: String) = uiJsI.setStatusBarColor(body)

    @JavascriptInterface
    fun AppBoxoWebAppSetPullToRefresh(body: String) = uiJsI.setPullToRefresh(body)

    @JavascriptInterface
    fun AppBoxoWebAppStopPullToRefresh(body: String) = uiJsI.stopPullToRefresh()
    //endregion

    //region Storage JS Interfaces
    @JavascriptInterface
    fun AppBoxoWebAppStorageGet(body: String) = storageJsI.storageGet(body)

    @JavascriptInterface
    fun AppBoxoWebAppStorageGetKeys(body: String) = storageJsI.storageGetKeys(body)

    @JavascriptInterface
    fun AppBoxoWebAppStorageSet(body: String) = storageJsI.storageSet(body)

    @JavascriptInterface
    fun AppBoxoWebAppStorageRemove(body: String) = storageJsI.storageRemove(body)

    @JavascriptInterface
    fun AppBoxoWebAppStorageClear(body: String) = storageJsI.storageClear(body)
    //endregion


    //region System JS Interfaces
    @JavascriptInterface
    fun AppBoxoWebAppVibrate(body: String) = vibrationJsI.appVibrate(body)

    @JavascriptInterface
    fun AppBoxoWebAppSetClipboard(body: String) = clipboardJsI.setClipboard(body)

    @JavascriptInterface
    fun AppBoxoWebAppGetClipboard(body: String) = clipboardJsI.getClipboard(body)

    @JavascriptInterface
    fun AppBoxoWebAppGetSystemInfo(body: String) = systemJsI.getSystemInfo(body)

    @JavascriptInterface
    fun AppBoxoWebAppDownloadFile(body: String) = systemJsI.downloadFile(body)

    @JavascriptInterface
    fun AppBoxoWebAppShare(body: String) = systemJsI.share(body)
    //endregion


    //region Location JS Interfaces
    @JavascriptInterface
    fun AppBoxoWebAppGetGeodata(body: String) = locationJsI.getGeodata(body)

    @JavascriptInterface
    fun AppBoxoWebAppOpenLocation(body: String) = locationJsI.openLocation(body)

    @JavascriptInterface
    fun AppBoxoWebAppChooseLocation(body: String) = locationJsI.chooseLocation(body)
    //endregion


    //region Sensor JS Interfaces
    @JavascriptInterface
    fun AppBoxoWebAppStartAccelerometer(body: String) = sensorJsI.startAccelerometer(body)

    @JavascriptInterface
    fun AppBoxoWebAppStopAccelerometer(body: String) = sensorJsI.stopAccelerometer(body)

    @JavascriptInterface
    fun AppBoxoWebAppStartGyroscope(body: String) = sensorJsI.startGyroscope(body)

    @JavascriptInterface
    fun AppBoxoWebAppStopGyroscope(body: String) = sensorJsI.stopGyroscope(body)

    @JavascriptInterface
    fun AppBoxoWebAppStartCompass(body: String) = sensorJsI.startCompass(body)

    @JavascriptInterface
    fun AppBoxoWebAppStopCompass(body: String) = sensorJsI.stopCompass(body)
    //endregion
}