package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.IClipboardEvents
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class ClipboardJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: IClipboardEvents
) {

    fun setClipboard(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            val data = json.getString("data")
            requestId to data
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (requestId, data) -> handler.post { events.setClipboard(requestId, data) } }
    }

    fun getClipboard(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            requestId
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { requestId -> handler.post { events.getClipboard(requestId) } }
    }

}