package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.ICustomEvents
import io.boxo.js.params.toCustomEvent
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class CustomEventsJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: ICustomEvents,
    private val boxo: Boxo
) {
    fun customEvent(body: String) {
        runCatching { JSONObject(body).toCustomEvent() }
            .onFailure { boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.customEvent(it) } }
    }
}