package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.ILocationEvents
import io.boxo.js.params.toLocationParam
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class LocationJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: ILocationEvents
) {
    fun getGeodata(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("request_id")
        }
            .onSuccess { requestId -> handler.post { events.getGeolocation(requestId) } }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
    }

    fun openLocation(body: String) {
        runCatching { JSONObject(body).toLocationParam() }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.openLocation(it) } }
    }

    fun chooseLocation(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            requestId
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.chooseLocation(it) } }
    }
}