package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.IMiniappEvents
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class MiniappJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: IMiniappEvents,
    private val boxo: Boxo
) {
    fun getMiniappSettings(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("request_id")
        }
            .onFailure { boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { requestId -> handler.post { events.getMiniappSettings(requestId) } }
    }

    fun getInitData(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("request_id")
        }
            .onFailure { boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { requestId -> handler.post { events.getInitialData(requestId) } }
    }

    fun openMiniapp(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("app_id") to json
        }
            .onFailure { boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (appId, json) -> handler.post { events.openNewMiniapp(appId, json) } }
    }

    fun closeMiniapp(body: String) {
        handler.post { events.closeMiniapp() }
    }

}