package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.IPaymentEvents
import io.boxo.js.params.toPaymentData
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class PaymentEventsJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: IPaymentEvents,
    private val boxo: Boxo
) {
    fun paymentEvent(body: String) {
        runCatching { JSONObject(body).toPaymentData() }
            .onFailure { boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.paymentEvent(it) } }
    }
}