package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.ISensorEvents
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class SensorJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: ISensorEvents
) {
    fun startAccelerometer(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            val interval = json.getInt("interval")
            requestId to interval
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (requestId, interval) -> handler.post { events.startAccelerometer(requestId, interval) } }
    }

    fun stopAccelerometer(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            requestId
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.stopAccelerometer(it) } }
    }


    fun startGyroscope(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            val interval = json.getInt("interval")
            requestId to interval
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (requestId, interval) ->
                handler.post {
                    events.startGyroscope(requestId, interval)
                }
            }
    }

    fun stopGyroscope(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            requestId
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.stopGyroscope(it) } }
    }

    fun startCompass(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            requestId
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { requestId -> handler.post { events.startCompass(requestId) } }
    }

    fun stopCompass(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            requestId
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.stopCompass(it) } }
    }
}