package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.ISystemEvents
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class SystemJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: ISystemEvents
) {

    fun getSystemInfo(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            requestId
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { requestId -> handler.post { events.getSystemInfo(requestId) } }
    }

    fun downloadFile(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("url") to
                    json.getString("file_name")
        }.onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (url, filename) -> handler.post { events.downloadFile(url, filename) } }
    }

    fun share(body: String) {
        runCatching {
            val json = JSONObject(body)
            Triple(
                json.optString("text") ?: "",
                json.optString("url") ?: "",
                json.optString("file_name") ?: ""
            )
        }.onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (text, url, filename) ->
                handler.post {
                    events.share(text, url, filename)
                }
            }
    }
}