package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.ITransactionEvents
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class TransactionJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: ITransactionEvents
) {

    fun transactionTrack(body: String) {
        runCatching {
            val json = JSONObject(body)
            val requestId = json.getString("request_id")
            val payload = json.getString("payload")
            requestId to payload
        }.onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { (requestId, payload) ->
                handler.post { events.transactionTrack(requestId, payload) }
            }
    }

}