package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.IUIEvents
import io.boxo.js.params.toActionButton
import io.boxo.js.params.toActionSheet
import io.boxo.js.params.toAlert
import io.boxo.js.params.toNavigationBar
import io.boxo.js.params.toPullToRefresh
import io.boxo.js.params.toTabBar
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class UiJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: IUIEvents
) {
    fun setTabBar(body: String) {
        runCatching { JSONObject(body).toTabBar() }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.setTabBar(it) } }
    }

    fun setNavigationBar(body: String) {
        runCatching { JSONObject(body).toNavigationBar() }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.setNavigationBar(it) } }
    }

    fun setActionButton(body: String) {
        runCatching {
            JSONObject(body).toActionButton()
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.setActionButtons(it) } }
    }

    fun setPullToRefresh(body: String) {
        runCatching {
            JSONObject(body).toPullToRefresh()
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.setPullToRefresh(it) } }
    }

    fun stopPullToRefresh() {
        handler.post { events.stopPullToRefresh() }
    }

    fun loadingIndicator(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getBoolean("show")
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { show -> handler.post { events.loadingIndicator(show) } }
    }

    fun openQRCodeReader(body: String) {
        handler.post { events.showQrCodeReader() }
    }

    fun showActionSheet(body: String) {
        runCatching { JSONObject(body).toActionSheet() }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.showActionSheet(it) } }
    }

    fun showAlert(body: String) {
        runCatching { JSONObject(body).toAlert() }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.showAlert(it) } }
    }

    fun showImages(body: String) {
        runCatching {
            val jsonArray = JSONObject(body).getJSONArray("images")
            val images = mutableListOf<String>()
            for (i in 0 until jsonArray.length())
                images.add(jsonArray.getString(i))
            images
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.showGallery(it) } }
    }

    fun setBackgroundColor(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("color")
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.setBackgroundColor(it) } }
    }

    fun setStatusBarColor(body: String) {
        runCatching {
            val json = JSONObject(body)
            json.getString("color")
        }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.setStatusBarColor(it) } }
    }
}