package io.boxo.js.jsInterfaces

import android.os.Handler
import io.boxo.js.events.IVibrationEvents
import io.boxo.js.params.toHapticFeedback
import io.boxo.log.exceptions.InvalidJsonException
import io.boxo.sdk.Boxo
import org.json.JSONObject

internal class VibrationJsI(
    private val appId: String,
    private val handler: Handler,
    private val events: IVibrationEvents
) {
    fun appVibrate(body: String) {
        runCatching { JSONObject(body).toHapticFeedback() }
            .onFailure { Boxo.logger.error(appId, InvalidJsonException(it)) }
            .onSuccess { handler.post { events.vibrate(it) } }
    }
}