package io.boxo.js.params

import org.json.JSONObject

internal data class ActionButton(
    val isLight: Boolean?,
    val visible: Boolean?,
    val style: Style?
) {
    enum class Style { default, style_1, style_2, style_3, style_4 }
}

internal fun JSONObject.toActionButton(): ActionButton {
    return ActionButton(
        isLight = if (has("isLight")) optBoolean("isLight") else null,
        visible = if (has("visible")) optBoolean("visible") else null,
        style = if (has("style"))
            runCatching { ActionButton.Style.valueOf(optString("style")) }
                .getOrNull() else null
    )
}