package io.boxo.js.params

import org.json.JSONObject

class ActionSheet(
    val header: String,
    val list: List<Item>
) {
    class Item(
        val id: Int,
        val text: String,
        val role: String?
    )
}

internal fun JSONObject.toActionSheet(): ActionSheet {
    return ActionSheet(
        header = runCatching { getString("header") }.getOrDefault(""),
        list = runCatching {
            val array = getJSONArray("list")
            val list = mutableListOf<ActionSheet.Item>()
            for (i in 0 until array.length()) {
                val itemJson = array.getJSONObject(i)
                val item = ActionSheet.Item(
                    id = runCatching { itemJson.getInt("id") }.getOrDefault(0),
                    text = runCatching { itemJson.getString("text") }.getOrDefault(""),
                    role = runCatching { itemJson.getString("role") }.getOrNull()
                )
                list.add(item)
            }
            list
        }.getOrDefault(emptyList())
    )
}