package io.boxo.js.params

import org.json.JSONObject

class Alert(
    val requestId: String,
    val header: String?,
    val message: String?,
    val buttons: List<Item>
) {
    class Item(
        val id: Int,
        val text: String,
        val role: String?
    )
}

internal fun JSONObject.toAlert(): Alert {
    return Alert(
        requestId = runCatching { getString("request_id") }.getOrThrow(),
        header = runCatching { getString("header") }.getOrNull(),
        message = runCatching { getString("message") }.getOrNull(),
        buttons = runCatching {
            val array = getJSONArray("buttons")
            val list = mutableListOf<Alert.Item>()
            for (i in 0 until array.length()) {
                val itemJson = array.getJSONObject(i)
                val item = Alert.Item(
                    id = runCatching { itemJson.getInt("id") }.getOrDefault(0),
                    text = runCatching { itemJson.getString("text") }.getOrDefault(""),
                    role = runCatching { itemJson.getString("role") }.getOrNull()
                )
                list.add(item)
            }
            list
        }.getOrDefault(emptyList())
    )
}