package io.boxo.js.params

import io.boxo.utils.toMap
import org.json.JSONObject

class CustomEvent(
    var requestId: Int?,
    var type: String,
    var errorType: String?,
    var payload: Map<String, Any>
) {
    internal fun toJson(): String {
        return JSONObject().apply {
            requestId?.let { put("request_id", it) }
            errorType?.let { put("error_type", it) }
            put("type", type)
            put("payload", JSONObject(payload))
        }.toString()
    }
}

internal fun JSONObject.toCustomEvent(): CustomEvent {
    return CustomEvent(
        requestId = runCatching { getInt("request_id") }.getOrNull(),
        type = runCatching { getString("type") }.getOrThrow(),
        payload = runCatching {
            val json = getJSONObject("payload")
            json.toMap()
        }.getOrDefault(emptyMap()),
        errorType = runCatching { getString("error_type") }.getOrNull()
    )
}