package io.boxo.js.params

import org.json.JSONObject
import java.io.Serializable

class LocationParam(
    val requestId: String,
    val latitude: Double,
    val longitude: Double,
    val scale: Double?
) : Serializable

internal fun JSONObject.toLocationParam(): LocationParam {
    return LocationParam(
        requestId = runCatching { getString("request_id") }.getOrThrow(),
        latitude = runCatching { getDouble("latitude") }.getOrThrow(),
        longitude = runCatching { getDouble("longitude") }.getOrThrow(),
        scale = runCatching { getDouble("scale") }.getOrNull()
    )
}
