package io.boxo.js.params

import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import org.json.JSONObject

@Parcelize
data class NavigationBar(
    val title: String? = null,
    val backButton: Boolean? = null,
    val background: String? = null,
    val frontColor: String? = null,
    val show: Boolean? = null,
    val isBackgroundTransparent: Boolean? = null,
    val frontColorWhenTransparent: String? = null,
    val changeBackgroundOnScroll: Boolean? = null
) : Parcelable {
    fun merge(navigationBar: NavigationBar): NavigationBar {
        var newNavBar = copy()
        navigationBar.title?.let { newNavBar = newNavBar.copy(title = it) }
        navigationBar.backButton?.let { newNavBar = newNavBar.copy(backButton = it) }
        navigationBar.background?.let { newNavBar = newNavBar.copy(background = it) }
        navigationBar.frontColor?.let { newNavBar = newNavBar.copy(frontColor = it) }
        navigationBar.show?.let { newNavBar = newNavBar.copy(show = it) }
        navigationBar.isBackgroundTransparent?.let { newNavBar = newNavBar.copy(isBackgroundTransparent = it) }
        navigationBar.frontColorWhenTransparent?.let { newNavBar = newNavBar.copy(frontColorWhenTransparent = it) }
        navigationBar.changeBackgroundOnScroll?.let { newNavBar = newNavBar.copy(changeBackgroundOnScroll = it) }
        return newNavBar
    }

}

internal fun JSONObject.toNavigationBar(): NavigationBar {
    return NavigationBar(
        title = runCatching { getString("title") }.getOrNull(),
        backButton = runCatching { getBoolean("backButton") }.getOrNull(),
        background = runCatching { getString("background") }.getOrNull(),
        frontColor = runCatching { getString("frontColor") }.getOrNull(),
        isBackgroundTransparent = runCatching { getBoolean("isBackgroundTransparent") }.getOrNull(),
        frontColorWhenTransparent = runCatching { getString("frontColorWhenTransparent") }.getOrNull(),
        changeBackgroundOnScroll = runCatching { getBoolean("changeBackgroundOnScroll") }.getOrNull(),
        show = runCatching { getBoolean("show") }.getOrNull()
    )
}