package io.boxo.js.params

import io.boxo.utils.toMap
import org.json.JSONObject

class PaymentData(
    var transactionToken:String,
    var miniappOrderId: String,
    var amount: Double,
    var currency: String,
    var status: String = "",
    var hostappOrderId:String="",
    var extraParams: Map<String, Any>?
) {
    internal fun toJson(): String {
        return JSONObject().apply {
            put("miniappOrderId", miniappOrderId)
            put("hostappOrderId", hostappOrderId)
            put("amount", amount)
            put("currency", currency)
            put("status", status)
            put("transactionToken", transactionToken)
            extraParams?.let { put("extraParams", JSONObject(it)) }
        }.toString()
    }
}

internal fun JSONObject.toPaymentData(): PaymentData {
    return PaymentData(
        transactionToken = runCatching { getString("transactionToken") }.getOrDefault(""),
        miniappOrderId = runCatching { getString("miniappOrderId") }.getOrDefault(""),
        amount = runCatching { getDouble("amount") }.getOrDefault(0.0),
        currency = runCatching { getString("currency") }.getOrDefault(""),
        extraParams = runCatching {
            val json = getJSONObject("extraParams")
            json.toMap()
        }.getOrNull()
    )
}