package io.boxo.js.params

import org.json.JSONObject

internal class PullToRefresh(
    val enabled: Boolean,
    val backgroundColor: String,
    val textColor: String,
    val pullText: String,
    val releaseText: String,
    val loadingText: String
)

internal fun JSONObject.toPullToRefresh(): PullToRefresh {
    return PullToRefresh(
        enabled = optBoolean("enabled"),
        backgroundColor = optString("backgroundColor"),
        textColor = optString("textColor"),
        pullText = optString("pullText"),
        releaseText = optString("releaseText"),
        loadingText = optString("loadingText")
    )
}