package io.boxo.log

import android.util.Log

class DefaultLogger(private var logEnabled: Boolean) : Logger {
    private val TAG = "BoxoSDK"

    enum class Level {
        DEBUG, ERROR
    }

    private fun log(level: Level, message: String) {
        if (logEnabled) {
            when (level) {
                Level.DEBUG -> {
                    Log.d(TAG, message)
                }
                Level.ERROR -> {
                    Log.e(TAG, message)
                }
            }
        }
    }

    override fun error(error: Throwable) = log(Level.ERROR, Log.getStackTraceString(error))
    override fun debug(message: String) = log(Level.DEBUG, message)
}