package io.boxo.log

import io.boxo.data.network.SentryService
import io.boxo.log.exceptions.InvalidJsonException
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.launch

internal class InternalLogger(
    private val logger: Logger,
    private val sentry: SentryService
) : Logger {
    fun error(appId: String, error: Throwable) {
        error(error)
        if (error is InvalidJsonException) GlobalScope.launch {
            runCatching {
                sentry.sendErrorEvent(appId, "jssdk_json_error", error)
            }
        }
    }

    override fun error(error: Throwable) {
        logger.error(error)
    }

    override fun debug(message: String) {
        logger.debug(message)
    }
}