package io.boxo.ui.about

import android.content.Context
import android.os.Bundle
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import io.boxo.R
import io.boxo.data.storage.IBoxoStorage
import io.boxo.data.storage.BoxoStorage
import io.boxo.sdk.Boxo
import io.boxo.ui.main.BoxoActivity
import io.boxo.utils.extensions.applyBoxoStatusBarByTheme
import io.boxo.utils.extensions.bindView
import io.boxo.utils.extensions.setDefaultTheme
import io.boxo.utils.extensions.setMiniappLocale
import io.boxo.utils.extensions.show
import com.squareup.picasso.Picasso
internal class MiniappAboutActivity : AppCompatActivity() {
    private val storage: IBoxoStorage by lazy { BoxoStorage(this) }
    private val backBtn by bindView<View>(R.id.back_btn)
    private val logo by bindView<ImageView>(R.id.logo)
    private val miniappNameText by bindView<TextView>(R.id.miniapp_name_text)
    private val miniappName by bindView<View>(R.id.miniapp_name)
    private val companyNameText by bindView<TextView>(R.id.company_name_text)
    private val companyName by bindView<View>(R.id.company_name)
    private val descriptionText by bindView<TextView>(R.id.description_text)
    private val description by bindView<View>(R.id.description)
    private val companyWebsiteText by bindView<TextView>(R.id.company_website_text)
    private val companyWebsite by bindView<View>(R.id.company_website)
    private val privacyPolicyText by bindView<TextView>(R.id.privacy_policy_text)
    private val privacyPolicy by bindView<View>(R.id.privacy_policy)
    private val reportMiniapp by bindView<TextView>(R.id.report_miniapp)

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setDefaultTheme(Boxo)
        applyBoxoStatusBarByTheme(Boxo)
        setContentView(R.layout.boxo_activity_about)
        val appId = intent.getStringExtra(BoxoActivity.APP_ID) ?: return
        val app = storage.getMiniappSettings(appId)?.miniappInfo ?: return
        if (app.logo.isNotBlank()) {
            Picasso.get().load(app.logo).into(logo)
        }
        miniappName.show(app.name.isNotBlank())
        miniappNameText.text = app.name
        description.show(app.description.isNotBlank())
        descriptionText.text = app.description
        backBtn.setOnClickListener { finish() }
    }

    override fun attachBaseContext(newBase: Context?) {
        setMiniappLocale()
        super.attachBaseContext(newBase)
    }
}